#include "mbed.h"

#include "MockSensorController.h"
#include "SensorAlarmController.h"
#include "PIDController.h"
#include "testing.h"


void TestCase::assert(bool b, const char *error) {
    if(!b) {
        printf("[%s] ASSERTION FAILED: %s\r\n", this->name, error);
        this->failed = true;
    }    
}

MOCK(temp_mock_steady, 35.0);
MOCK(salt_mock_steady, 6.1);
MOCK(prox_mock_steady, 500.0);


MOCK(temp_mock1, 40.1+(t/1000.0));
ALARM_TEST(testTempDangerousHighAlarm, temp_mock1, salt_mock_steady, prox_mock_steady, NUMBER_OF_SEC_BEFORE_CRITICAL_ALARM+1);

MOCK(temp_mock2, 29.9-(t/1000.0));
ALARM_TEST(testTempDangerousLowAlarm, temp_mock2, salt_mock_steady, prox_mock_steady, NUMBER_OF_SEC_BEFORE_CRITICAL_ALARM+1);

MOCK(temp_mock3, 30+(t*0.000001));
ALARM_TEST(testTempLowRangeAlarm, temp_mock3, salt_mock_steady, prox_mock_steady, NUMBER_OF_SEC_BEFORE_UNDESIRED_ALARM+1);

MOCK(temp_mock4, 38+(t*0.000001));
ALARM_TEST(testTempHighRangeAlarm, temp_mock4, salt_mock_steady, prox_mock_steady, NUMBER_OF_SEC_BEFORE_UNDESIRED_ALARM+1);

MOCK(overflow_undesired_mock, 900+(t/4000.0));
ALARM_TEST(testAlarmWaterOverflowUndesired, temp_mock_steady, salt_mock_steady, overflow_undesired_mock, NUMBER_OF_SEC_BEFORE_UNDESIRED_ALARM+1);

MOCK(overflow_critical_mock, 1001+(t/4000.0));
ALARM_TEST(testAlarmWaterOverflowCritical, temp_mock_steady, salt_mock_steady, overflow_critical_mock, NUMBER_OF_SEC_BEFORE_CRITICAL_ALARM+1);

MOCK(leak_undesired_mock, 1+(t/4000.0));
ALARM_TEST(testAlarmWaterLeakUndesired, temp_mock_steady, salt_mock_steady, leak_undesired_mock, NUMBER_OF_SEC_BEFORE_UNDESIRED_ALARM+1);

MOCK(leak_critical_mock, -1-(t/4000.0));
ALARM_TEST(testAlarmWaterLeakCritical, temp_mock_steady, salt_mock_steady, leak_critical_mock, NUMBER_OF_SEC_BEFORE_CRITICAL_ALARM+1);

MOCK(salinity_mock1, 3.1+(t*0.000005));
ALARM_TEST(testSalinityLowRangeAlarm, temp_mock_steady, salinity_mock1, prox_mock_steady, NUMBER_OF_SEC_BEFORE_UNDESIRED_ALARM+1);

MOCK(salinity_mock2, 9.1+(t*0.000005));
ALARM_TEST(testSalinityHighRangeAlarm, temp_mock_steady, salinity_mock2, prox_mock_steady, NUMBER_OF_SEC_BEFORE_UNDESIRED_ALARM+1);

MOCK(salinity_mock3, 2.9-(t*0.000005));
ALARM_TEST(testSalinityDangerousLowAlarm, temp_mock_steady, salinity_mock3, prox_mock_steady, NUMBER_OF_SEC_BEFORE_CRITICAL_ALARM+1);

MOCK(salinity_mock4, 12.1+(t*0.000005));
ALARM_TEST(testSalinityDangerousHighAlarm, temp_mock_steady, salinity_mock4, prox_mock_steady, NUMBER_OF_SEC_BEFORE_CRITICAL_ALARM+1);

MOCK(temp_heating_mock, 29+(0.001*t));
bool testTemperatureHeater(TestCase *tc) {
    DEF_MOCKS(temp_heating_mock, salt_mock_steady, prox_mock_steady);
    PIDController pidc(false,0,&temp,&salt,&prox);
    
    pidc.run();
    tc->assert(pidc.isHeating(), "PIDController should be heating at temp=29!");
    Thread::wait(1000);
    
    pidc.run();
    tc->assert(pidc.isHeating(), "PIDController should be heating at temp=30!");
    Thread::wait(1000);
    
    pidc.run();
    tc->assert(pidc.isHeating(), "PIDController should be heating at temp=31!");
    Thread::wait(2500);
    
    pidc.run();
    tc->assert(!pidc.isHeating(), "PIDController shouldn't be heating at temp=33.5!");
    
    return true;    
}


MOCK(salinity_mock5, 1.0f);
MOCK(salinity_mock6, 2.0f);
MOCK(salinity_mock7, 4.0f);
MOCK(salinity_mock8, 7.0f);
MOCK(salinity_mock10, 10.0f);
MOCK(salinity_mock11, 14.0f);
MOCK(vol_mock1, 600.0f);

bool testPumps1(TestCase *tc) {
    
    Thread::wait(5000);
    
    DEF_MOCKS(temp_mock_steady, salinity_mock11, vol_mock1);
    PIDController pidc(false,0,&temp,&salt,&prox);
    
    temp.run();
    salt.run();
    prox.run();
    
    pidc.run();
    
    printf("Manually verify the amount of salty water pumped for 2.0f salt and 600ml volume\r\n");
    
    Thread::wait(5000);
    
    return true;
}





int testMain() {
    
    START_TESTS();
    
    /*TESTCASE("Test if alarm is raised when temp > 40 for 30 seconds", testTempDangerousHighAlarm);
    TESTCASE("Test if alarm is raised when temp < 30 for 30 seconds", testTempDangerousLowAlarm);
    TESTCASE("Test if alarm is raised when temp > 30 and < 32 for 5 minutes", testTempLowRangeAlarm);
    TESTCASE("Test if alarm is raised when temp > 38 and < 40 for 5 minutes", testTempHighRangeAlarm);
    
    TESTCASE("Test if alarm is raised when salinity > 3 and < 6 for 5 minutes", testSalinityLowRangeAlarm);
    TESTCASE("Test if alarm is raised when salinity > 9 and < 12 for 5 minutes", testSalinityHighRangeAlarm);
    TESTCASE("Test if alarm is raised when salinity < 3 for 30 seconds", testSalinityDangerousLowAlarm);
    TESTCASE("Test if alarm is raised when salinity > 12 for 30 seconds", testSalinityDangerousHighAlarm);
    
    TESTCASE("Test if heater gets enabled at < 32 and disabled at 33+", testTemperatureHeater);
    
    TESTCASE("Test if alarm is raised when water tank level in range 900-1000 ml for 5 minutes", testAlarmWaterOverflowUndesired);
    TESTCASE("Test if alarm is raised when water tank level is 1001 for 30 seconds", testAlarmWaterOverflowCritical);
    TESTCASE("Test if alarm is raised when water tank level is in range 0-100 ml for 5 minutes", testAlarmWaterLeakUndesired);
    TESTCASE("Test if alarm is raised when water tank level is < 0 for 30 seconds", testAlarmWaterLeakCritical);
    */
    TESTCASE("Test pump at 1.0f ppt salinity and 600ml volume", testPumps1);
    
    END_TESTS();
    
    return 0;
}