#include "ProximityController.h"
#include "SensorAlarmController.h"

static Ping pinger(p30);
static DigitalOut alarmled(LED3);

void ProximityController::update() {
    int range;
     
    pinger.Send();    
    Thread::wait(30);
    range = pinger.Read_cm()/ 2;   
    this->distance = (float)range;
    
    printf("Read distance: %.3f\r\n", distance);
    
    if(distance < 0.01) {
        SensorAlarmController::buzzOnce();
        setLed(true);
    } else {
        setLed(false);
    }
}        

float ProximityController::getDistance() {
    return this->distance;
}

float ProximityController::getValue() {
    if(distance < 0.01) {
        this->volume = -1.0f;    
    } else {
        this->volume = (DISTANCE_TO_BASE - this->distance) * 76.92f;
    }
    
    return this->volume;    
}

std::string ProximityController::getName() {
    return "ProximityController";
}

void ProximityController::setLed(bool value){
    if (value) alarmled = 1;
    if (!value) alarmled = 0;
}