#ifndef __PIDCONTROLLER_H__
#define __PIDCONTROLLER_H__

#include <iostream>

#include "mbed.h"
#include "DRV8825.h"
#include "stdio.h"
#include "SensorController.h"
#include "settings.h"


#define MAX_SPEED           8000
#define MICROSTEPS_PER_STEP 16 

#define LEFT  1
#define RIGHT 0


class PIDController : public Controller {

    
    public:
        PIDController(bool threaded, int interval_ms, SensorController *temp, SensorController *salt, SensorController *proximity)
         : Controller(threaded, interval_ms) {
            this->temp = temp;
            this->salt = salt;
            this->proximity = proximity;
            this->pumping = false;
            this->heating = false;
        }
        
        ~PIDController();
        
        virtual void update();
        
        virtual std::string getName();
        
        bool isHeating();
        
        bool isPumping();
        
        void doTestingStuff(int ml);
    
    private:
        SensorController *temp;
        SensorController *salt;
        SensorController *proximity;        
        
        bool heating;
        bool pumping;
        
        void pumpSaltWater(int ml);
        
        void pumpFreshWater(int ml);
        
        void pumpWater(DRV8825 *mtr, int ml);
        
        float getMlSaltyWater(float, float);
        
        float getMlFreshWater(float, float);
        
        float getSaltInGrams();
        
        void setHeating(bool enabled);       
};


#endif