#ifndef __MOCKSENSORCONTROLLER_H__
#define __MOCKSENSORCONTROLLER_H__

#include "mbed.h"

#include "SensorController.h"

class MockSensorController : public SensorController {
    public:
        MockSensorController(bool threaded, int interval_ms, float (*func)(int, int)) : SensorController(threaded, interval_ms) {
            this->func = func;  
            t.start();  
        }  
        
        virtual void update();
        
        virtual float getValue();
        
        virtual std::string getName();
        
        virtual void setLed(bool);
    
    private:
        int i;
        Timer t;
        long int sum_t;
        float (*func)(int, int);
};

#endif