#include "LCDController.h"
#include "SensorAlarmController.h"

static TextLCD lcd(p5, p6, p7, p8, p9, p10, TextLCD::LCD16x2);


LCDController::LCDController() {
    printf("Initiate LCD Controller\n\r");
    lcd.cls();
}


void LCDController::splash() {
    lcd.cls();
    lcd.printf("Welcome to\nSaltware");
    wait(0.5);   
}    

void LCDController::updateScreen(float temp_value, float salt_value, PIDController *pidc) {
     lcd.cls();
     
     char temp_buffer[16];
     char salt_buffer[16];
     
     if (temp_value > 100) {
         // Show Not Connected
         sprintf(temp_buffer, "T: NC");
         SensorAlarmController::buzzOnce();
     } else {
         sprintf(temp_buffer, "T: %.1fC", temp_value);
     }
     
     if (pidc->isHeating()) {
          // Indicate heating with an "*" near the temperature
          sprintf(temp_buffer, "%s *", temp_buffer);   
     }
     
     if(salt_value < MIN_VALID_SALINITY) {
        // Show not connected
        sprintf(salt_buffer, "S: NC");
        SensorAlarmController::buzzOnce();
     } else {
        sprintf(salt_buffer, "S: %.3fPPT", salt_value);
     }
     
     // Indicate pumping with an "*" near the salinity
     if (pidc->isPumping()) {
         sprintf(salt_buffer, "%s *", salt_buffer);
     }   

     lcd.printf("%s\n%s", temp_buffer, salt_buffer);  
}

void LCDController::showPumping() {
    lcd.cls();
    lcd.printf("Now pumping...");
}

void LCDController::updateScreen(float volume) {
    lcd.cls();
    
    if(-1.0f == volume)
        lcd.printf("Volume:\nNC");
    else if(volume > VOLUME_MAX_CRIT)
        lcd.printf("Volume:\nOverflow");
    else if(volume < VOLUME_MIN_CRIT)
        lcd.printf("Volume:\nUnderflow");
    else
        lcd.printf("Volume:\nOK");
}

void LCDController::showError(const char *msg) {
    lcd.cls();
    lcd.printf("ERROR:\n%s", msg);    
}