#include "SalinityController.h"

static AnalogIn salinity_sensor(p19);
static DigitalOut alarmled(LED2);

//Read the sensor, update the local variable.
void SalinityController::update() {
    this->salinity = SalinityController::getAdjustedPPT();
}

//Return the value, this function does not update the value.
float SalinityController::getValue() {
    return this->salinity;    
}

//Read the voltage, get an average over NUM_MEASUREMENTS values defined in settings.h
float SalinityController::getVoltage() {
    float voltage = 0;
    float analogin_value = 0;
    
    // Read 0-1.0 value
    for(int i = 0; i < NUM_MEASUREMENTS; i++) {
        analogin_value += salinity_sensor.read();
        //Thread::wait(MEASUREMENT_DELAY);
    }
    
    analogin_value /= (float) NUM_MEASUREMENTS;    
    voltage = analogin_value * 3.3f * (5.0f/3.0f);
    
    return voltage;
}

//Convert inputvolt to corrected sensor value
float SalinityController::voltToSensor(float inputvolt) {
    float slope = 0.7931723;
    float intercept = 0.0050561;
    
    float offset = (slope * inputvolt) - intercept;
    
    return inputvolt + offset;
}

//Convert corrected sensor value to actual PPT
float SalinityController::sensorToPPT(float inputvolt) {
    float slope = 11.53368;
    float intercept = 0.43580;    
    float minimum = 0.03778499;
    
    if (inputvolt <= minimum) 
        return 0.00;
    
    return (slope * inputvolt) - intercept;
}

//Chain the needed functions to get the proper PPT
float SalinityController::getAdjustedPPT() {
  return sensorToPPT(voltToSensor(getVoltage()));   
}


std::string SalinityController::getName() {
    return "SalinityController";
}

void SalinityController::setLed(bool value){
    if (value) alarmled = 1;
    if (!value) alarmled = 0;
}