#ifndef __TEMPERATURECONTROLLER_H__
#define __TEMPERATURECONTROLLER_H__

#include "mbed.h"
#include "settings.h"
#include "SensorController.h"


/** The TemperatureController measures the Vernier temperature probe.
 */
class TemperatureController : public SensorController {
    public:
        /**
         * Constructs a new TemperatureController that measures and averages the value from the temperature probe.
         * @param threaded whether or not the controller should be threaded.
         * @param interval_ms delay between each iteration, only if threaded is set to \a true.
         */
        TemperatureController(bool threaded, int interval_ms) : SensorController(threaded, interval_ms) {printf("Initiate Temperature Controller\r\n");}

        /** Returns the Temperature measured (in Celsius) during the last update() */
        virtual float getValue();

        /** Measures the Temperature N times and stores the average value of these measurements. */
        virtual void update();

        /** Returns "TemperatureController" */
        virtual std::string getName();
        
        virtual void setLed(bool);

    private:
        /**
         * The latest temperature measurement, average of N measurements.
         */
        float temperature;

        /**
         * This reads the temperature.
         * @return Return the average temperature over N reads in Celsius.
         */
        static float readSensor();

        /**
         * Returns value read from mbed to Celsius.
         * @return temperature in Celsius.
         */
        static float analoginToCelsius(float);

        /**
         * Adjusts value for measurement mistakes.
         * @return adjusted value in volt.
         */
        static float getOffset(float);

};

#endif
