#include "TemperatureController.h"

static AnalogIn temperature_sensor(p20);
static DigitalOut alarmled(LED1);

float TemperatureController::getValue() {
    return this->temperature;    
}

std::string TemperatureController::getName() {
    return "TemperatureController";
}

void TemperatureController::update() {
    this->temperature = readSensor();
}

// Function reads sensor values and averages NUM_MEASUREMENTS sensor values, as defined in settings.h
float TemperatureController::readSensor() {
    float analogin_value = 0;
    float temperature = 0;
    
    // Read 0-1.0 value
    for(int i = 0; i < NUM_MEASUREMENTS; i++) {
        analogin_value += temperature_sensor.read();
        Thread::wait(MEASUREMENT_DELAY);
    }
    
    // Average N sensor values
    analogin_value /= (float) NUM_MEASUREMENTS;
    
    temperature = analoginToCelsius(analogin_value);
    
    return temperature;
}

// Function converts average sensor value to ppt
float TemperatureController::analoginToCelsius(float analogin_value) {
    float voltage = 0;
    float offset = 0;
    float rt = 0;
    float logrt = 0;
    float temperature = 0;
    
    // Convert average sensor value to value with range 0-5.0v
    voltage = analogin_value * 3.3f * (5.0f/3.0f);
    
    
    offset = getOffset(voltage);
    voltage += offset;
    
    // Calcuate R_T
    rt = (15000.0f * voltage) / (4.8f - voltage);
    
    logrt = log(rt);
    temperature = 1.0 / (0.00102119 + (0.000222468 * logrt) + (0.000000133342 * logrt*logrt*logrt));
    
    temperature = temperature - 273.15;
    
    return temperature;
}

float TemperatureController::getOffset(float voltage) {
    float denominator_voltage, numerator_voltage, ratio, interpolation;
    
    float voltage_table[15] = {1.43, 1.55, 1.53, 1.56, 1.62, 1.65, 1.67, 1.73, 1.75, 1.80, 1.82, 1.88, 1.93, 1.98, 2.00};
    float offset_table[15] = {0.33, 0.33, 0.40, 0.40, 0.39, 0.42, 0.43, 0.41, 0.45, 0.50, 0.54, 0.53, 0.52, 0.53, 0.56};
    
    for(int i = 0; i < 14; i++) {
        if(voltage_table[i] <= voltage && voltage_table[i+1] >= voltage) {
            denominator_voltage = voltage_table[i+1] - voltage_table[i];
            numerator_voltage = voltage - voltage_table[i];
            
            if(denominator_voltage != 0) {
                ratio = numerator_voltage / denominator_voltage;
                
                interpolation = ((offset_table[i+1] - offset_table[i]) * ratio) + offset_table[i];
                
                return interpolation;
            } else {
                return offset_table[i];
            }
        }
    }
    
    if(voltage_table[14] < voltage) {
        return offset_table[14];
    } else {
        return offset_table[0];
    }
}

void TemperatureController::setLed(bool value){
    if (value) alarmled = 1;
    if (!value) alarmled = 0;
}
    