#ifndef __TESTING_H__
#define __TESTING_H__


#include "mbed.h"
#include "settings.h"

class TestCase {

    public:
        TestCase(const char *name, bool (*evaluate)(TestCase *tc)) {
            this->name = name;
            this->evaluate = evaluate;
            this->failed = false;
            
            if(!failed && this->evaluate(this)) {
                printf("TESTCASE %s PASSED!\r\n", this->name);
            } else {
                printf("TESTCASE %s FAILED!\r\n", this->name);    
            }
        }
        
        void assert(bool b, const char *error);
    
        bool failed;
    
    private:
        const char *name;
        bool (*evaluate)(TestCase *tc);
    
};


#define MOCK(N, F) static inline float N(int i,int t) {return (F);}

#define DEF_MOCKS(A,B,C) MockSensorController temp(false,0,A); \
    MockSensorController salt(false,0,B); \
    MockSensorController prox(false,0,C);

#define ALARM_TEST(N,T,S,P,TIME) bool N(TestCase *tc) { \
    DEF_MOCKS(T,S,P); \
    SensorAlarmController temp_alarm(false,0,&temp,TEMP_MIN_CRIT, TEMP_MIN_UNDESIRED, TEMP_MAX_CRIT, TEMP_MAX_UNDESIRED); \
    SensorAlarmController salt_alarm(false,0,&salt,SALT_MIN_CRIT, SALT_MIN_UNDESIRED, SALT_MAX_CRIT, SALT_MAX_UNDESIRED); \
    SensorAlarmController prox_alarm(false,0,&salt,VOLUME_MIN_CRIT, VOLUME_MIN_UNDESIRED, VOLUME_MAX_CRIT, VOLUME_MAX_UNDESIRED); \
    for(int i = 0; i < TIME; i++) { \
        temp_alarm.run(); \
        salt_alarm.run(); \
        prox_alarm.run(); \
        Thread::wait(1000); \
    } \
    return temp_alarm.isError() || salt_alarm.isError() || prox_alarm.isError(); \
}

#define START_TESTS() int __num_failed=0; \
    int __num_passed = 0; \
    bool __pass = false;
    
#define TESTCASE(N,F) __pass = !TestCase(N,F).failed;\
    if(__pass) __num_passed++; \
    else __num_failed++;

#define END_TESTS() printf("====================================================\r\n"); \
    printf("Ran a total of %d test cases\r\n", __num_passed + __num_failed); \
    printf("Number of tests passed: %d\r\n", __num_passed); \
    printf("Number of tests failed: %d\r\n", __num_failed); \
    printf("====================================================\r\n"); 



#endif