#include "SensorAlarmController.h"


//outputpins for alarm
static DigitalOut buzzer(p17);
static DigitalOut led1(LED1);
static DigitalOut led2(LED2);
static DigitalOut led3(LED3);
static DigitalOut led4(LED4);

void SensorAlarmController::update() {
    
    #ifndef TEST_MODE
    if(this->num_iters < STARTUP_ITERATIONS) {
        cout << this->getName() << ": not running, startup phase";
        return;
    }
    #endif
    
    value = sensor->getValue();
    
    if ((value < min_undesired) || (value > max_undesired)) {
        if ((value < min_crit) || (value > max_crit)) {
            this->raiseAlarm(true);
        } else {
            this->raiseAlarm(false);
        }
    } else {
        //clear alarm
        printf("Clearing alarm: %s\r\n", this->getName().c_str());
        timer.stop();
        timer.reset();
        this->is_crit = false;
        sensor->setLed(false);
    }
    
}

void SensorAlarmController::raiseAlarm(bool isCrit) { 

    this->is_crit = isCrit;
    int readtimer = timer.read();
    
    if (isCrit)
        printf("Received a critical %s alarm %f timer is at %d\r\n", this->sensor->getName().c_str(), value, readtimer);
    if (!isCrit)
        printf("Received a non-critical %s alarm %f timer is at %d\r\n", this->sensor->getName().c_str(), value, readtimer);
    
    if (readtimer > 0 ) { //already running
        if ((readtimer >= NUMBER_OF_SEC_BEFORE_CRITICAL_ALARM && is_crit) ||
            (readtimer >= NUMBER_OF_SEC_BEFORE_UNDESIRED_ALARM && !is_crit)) {
            
            this->error = true;
            if (this->is_crit) {
                this->error_msg = this->error_msg_critical;
            } else {
                this->error_msg = this->error_msg_undesired;
            }
            
            printf("### %s alarm has been triggered after ### %d seconds\r\n", this->getName().c_str(), readtimer);
            sensor->setLed(true);
            buzzOnce();
            timer.stop();
            timer.reset();
            this->is_crit = false;
        }
    } else {
        timer.start();    
    }
}

std::string SensorAlarmController::getName() {
    return "AlarmController[" + this->sensor->getName() + "]";    
}

bool SensorAlarmController::isError() {
    return this->error;    
}

std::string SensorAlarmController::getErrorMessage() {
    return this->error_msg;
}

void SensorAlarmController::setCriticalErrorMsg(std::string msg) {
    this->error_msg_critical = msg;        
}
        
void SensorAlarmController::setUndesiredErrorMsg(std::string msg) {
    this->error_msg_undesired = msg;   
}

bool SensorAlarmController::isActive() {
    return this->timer.read() > 0;    
}

void SensorAlarmController::buzzOnce() {
    
    buzzer = 1;
    wait(0.1);
    buzzer = 0;
            
}