#include <iostream>

#include "Controller.h"

Controller::Controller(bool threaded = false, int interval_ms = 0) {
    this->threaded = threaded;
    this->interval_ms = interval_ms;
    this->ctrl_thread = 0;
    this->prio = osPriorityNormal;
    this->num_iters = 0;
}

bool Controller::isThreaded() {
    return this->threaded;    
}

void Controller::run() {
    if(!this->threaded) {
        this->update();    
    } else if(!this->has_spawned) {
        has_spawned = true; 
        Thread t (Controller::threadStub, this);
        this->ctrl_thread = &t;
    }
    
    this->num_iters++;
}

int Controller::getIntervalMs() {
    return this->interval_ms;    
}

void Controller::setPriority(osPriority priority) {
    this->prio = priority;
    if(this->has_spawned)
        this->ctrl_thread->set_priority(priority);
}

osPriority Controller::getPriority() {
    return this->prio;
}    

// Called when a thread is spawned.
void Controller::threadStub(void const *args) {
    Controller *controller = (Controller*)args;
    
    // Run forever.
    while(1) {
        std::cout << "[THREAD] running " << controller->getName() << "\r\n";
        controller->run();
        Thread::wait(controller->getIntervalMs());
    }
    
}