/**************************************** MAIN SETTINGS ****************************************/
//----------------------------------------------------------------------------------------------
// This file includes the system settings for Saltware such as boot parameters


// If defined the system runs in test mode and executes testMain() in testing.cpp
// Else the system runs in production mode and executes realMain() in main.cpp.
//#define TEST_MODE

#ifdef TEST_MODE
#define MAIN testMain
#else
#define MAIN realMain
#endif


// Do we stop the system after an alarm was raised?
#define HALT_ON_ALARM

// Number of iterations before the system tries to adjust values / raises an alarm
#define STARTUP_ITERATIONS 0

// Sleep for X ms after each iteration
#define MAIN_THREAD_DELAY_MS 1000

// Number of seconds before a critical alarm is raised
#define NUMBER_OF_SEC_BEFORE_CRITICAL_ALARM 30

// Number of seconds before an undesired alarm is raised
#define NUMBER_OF_SEC_BEFORE_UNDESIRED_ALARM 300


//Thresholds for temperature (in celcius)
#define TEMP_MIN_CRIT               30.0f
#define TEMP_MIN_UNDESIRED          32.0f
#define TEMP_MAX_CRIT               40.0f
#define TEMP_MAX_UNDESIRED          38.0f

//Thresholds for salinity (in ppt)
#define SALT_MIN_CRIT               3.0f
#define SALT_MIN_UNDESIRED          6.0f
#define SALT_MAX_CRIT               12.0f
#define SALT_MAX_UNDESIRED          9.0f

//Thresholds for overflow volumes (in ml)
#define VOLUME_MIN_CRIT             300.0f
#define VOLUME_MIN_UNDESIRED        300.0f
#define VOLUME_MAX_CRIT             800.0f
#define VOLUME_MAX_UNDESIRED        800.0f

// Distance between ultrasonic sensor and tank
#define DISTANCE_TO_BASE            18.0f

// Temerature and Salinity measurements
#define NUM_MEASUREMENTS            50
// Delay between each measurement in ms for the Temperature sensor
#define MEASUREMENT_DELAY           100

// Below this value, we assume salinity sensor is NC
#define MIN_VALID_SALINITY          0.15f

//----------------------------------------------------------------------------------------------
/***********************************************************************************************/