#ifndef __SENSORALARMCONTROLLER_H__
#define __SENSORALARMCONTROLLER_H__

#include <iostream>

#include "mbed.h"
#include "SensorController.h"
#include "PIDController.h"
#include "settings.h"

/** The AlarmController monitors a Sensor and registers unsafe values.
 * After a specified amount of time an alarm is raised by means of a buzzer.
 */
class SensorAlarmController  : public Controller {

    public:
    
        /** Contructs a new AlarmController which monitors the given SensorController. */
        SensorAlarmController(bool threaded, int interval_ms, SensorController *sensor,
            float min_crit, float min_undesired, float max_crit, float max_undesired)
         : Controller(threaded, interval_ms) {
            this->sensor = sensor;
            this->error = false;
            this->is_crit = false;        
            
            this->min_crit = min_crit;
            this->min_undesired = min_undesired;
            this->max_crit = max_crit;
            this->max_undesired = max_undesired;
            
            this->error_msg_critical = "crit alarm";
            this->error_msg_undesired = "undes alarm";
        }
        
        /** Overrides update() in the Controller class */
        virtual void update();
        
        /** Overrides get_name() in the Controller class */
        virtual std::string getName();
        
        /** Return \a true if there is an error condition and the alarm was raised. */
        bool isError();
        
        /** Returns a message describing the last error */
        std::string getErrorMessage();
        
        /** Activates the buzzer */
        static void buzzOnce();
        
        void setCriticalErrorMsg(std::string msg);
        
        void setUndesiredErrorMsg(std::string msg);
        
        bool isActive();

    
    private:
        SensorController *sensor;

        float value;
        bool error;
        std::string error_msg;
        bool is_crit;
        Timer timer;
        
        float min_crit;
        float min_undesired;
        float max_crit;
        float max_undesired;
        
        std::string error_msg_critical;
        std::string error_msg_undesired;
        
        
        /** Activates an alarm for the sensor controller */
        void raiseAlarm(bool);
        
};


#endif