#ifndef __SALINITYCONTROLLER_H__
#define __SALINITYCONTROLLER_H__

#include "mbed.h"
#include "stdio.h"
#include "settings.h"
#include "SensorController.h"


class SalinityController : public SensorController {
    public:
        SalinityController(bool threaded, int interval_ms) : SensorController(threaded, interval_ms) {}  
        
        virtual void update();
        
        virtual float getValue();
        
        virtual std::string getName();
        
        virtual void setLed(bool);
    
    private:
        float salinity;
        
        static float voltToSensor(float);
        
        static float sensorToPPT(float);
        
        static float getVoltage();
        
        static float getAdjustedPPT();
};

#endif