#ifndef __LCDCONTROLLER_H__
#define __LCDCONTROLLER_H__

#include "mbed.h"
#include "stdio.h"
#include "TextLCD.h"
#include "settings.h"
#include "PIDController.h"

/** Provides methods to write to the 16x2 LCD screen */
class LCDController {

    
    public:
        LCDController();
        
        /** Displays temperature / salinity values and shows if the heater is active or not */
        static void updateScreen(float, float, PIDController *pidc);
        
        /** Displays the volume in the water tank */
        static void updateScreen(float);
        
        /** Shows the splash screen */
        static void splash();
        
        /** Shows the given error, this is used by the AlarmController */
        static void showError(const char *msg);
        
        /** Displays a message showing the pumps are active */
        static void showPumping();
    
    private:
        
};

#endif