#include "mbed.h"
#include "MCP23017.h"

const unsigned __int64 FORWARD = 1;
const unsigned __int64 BACKWARD = 0;
const unsigned __int64 LIGHTON = 1;
const unsigned __int64 LIGHTOFF = 0;
const unsigned __int64 SLOW = 0x4; //0100 = step 5
const unsigned __int64 NORM = 0x9; //1001 = step 15
const unsigned __int64 FAST = 0xE; //1110 = step 25
const unsigned __int64 STOP = 0x1; //0001 = E-STOP

const unsigned __int64 train1 = 0x1; 
const unsigned __int64 train3 = 0x3;
const unsigned __int64 def_repeat_count = 5;

const int addr0 = 0x20 << 1;

int interrupted = 0;

I2C i2c(p28, p27);

DigitalOut Track(p20);
DigitalOut led(LED1);
InterruptIn int0(p25);
//InterruptIn int1(p9);

/* Write a register on an I2C device */
void mcpWriteReg(uint8_t address, uint8_t reg, uint8_t data){
    char cmd[2];
    cmd[0] = reg;
    cmd[1] = data;
    i2c.write(address, cmd, 2);   // Write 2 bytes to device on specified address
}

/* Read a register on a I2C device */
uint8_t mcpReadReg(uint8_t address, uint8_t reg){
    char cmd[1];
    cmd[0] = reg;
    i2c.write(address, cmd, 1);     // Write address 
    i2c.read(address, cmd, 1);      // Read value (one byte)
    return cmd[0];                  // Return the read value
}

void interrupt_handler(){
     interrupted = 1;
}

void initialize_mcp() {
    /*
    printf("%x\n", mcpReadReg(addr0, MCP_IODIRA));
    printf("%x\n", mcpReadReg(addr0, MCP_IODIRB));
    printf("%x\n", mcpReadReg(addr0, MCP_IPOLA));
    printf("%x\n", mcpReadReg(addr0, MCP_IPOLB));
    printf("%x\n", mcpReadReg(addr0, MCP_GPINTENA));
    printf("%x\n", mcpReadReg(addr0, MCP_GPINTENB));
    printf("%x\n", mcpReadReg(addr0, MCP_DEFVALA));
    printf("%x\n", mcpReadReg(addr0, MCP_DEFVALB));
    printf("%x\n", mcpReadReg(addr0, MCP_INTCONA));
    printf("%x\n", mcpReadReg(addr0, MCP_INTCONB));
    printf("%x\n", mcpReadReg(addr0, MCP_IOCON));
    printf("%x\n", mcpReadReg(addr0, MCP_IOCON_MIRROR));
    printf("%x\n", mcpReadReg(addr0, MCP_GPPUA));
    printf("%x\n", mcpReadReg(addr0, MCP_GPPUB));
    printf("%x\n", mcpReadReg(addr0, MCP_INTFA));
    printf("%x\n", mcpReadReg(addr0, MCP_INTFB));
    printf("%x\n", mcpReadReg(addr0, MCP_INTCAPA));
    printf("%x\n", mcpReadReg(addr0, MCP_INTCAPB));
    printf("%x\n", mcpReadReg(addr0, MCP_GPIOA));
    printf("%x\n", mcpReadReg(addr0, MCP_GPIOB));
    printf("%x\n", mcpReadReg(addr0, MCP_OLATA));
    printf("%x\n", mcpReadReg(addr0, MCP_OLATB));
    */
    
    mcpWriteReg(addr0, MCP_IODIRA, 0xff);     // All inputs 
    mcpWriteReg(addr0, MCP_IODIRB, 0xff);     // All inputs
    mcpWriteReg(addr0, MCP_GPINTENA, 0xff);
    mcpWriteReg(addr0, MCP_GPINTENB, 0xff);
    mcpWriteReg(addr0, MCP_INTCONA, 0xff);
    mcpWriteReg(addr0, MCP_INTCONB, 0xff);
    mcpWriteReg(addr0, MCP_DEFVALA, 0xff);
    mcpWriteReg(addr0, MCP_DEFVALB, 0xff);
    mcpWriteReg(addr0, MCP_GPIOA, 0x00);
    mcpWriteReg(addr0, MCP_GPIOB, 0x00);
    
    int0.fall(&interrupt_handler);
    //int1.fall(&interrupt_handler);
    
}

void DCC_send_command(unsigned int address, unsigned int inst, unsigned int repeat_count){
    unsigned __int64 command = 0x0000000000000000; // this is a 64-bit integer type, due to the packet size
    unsigned __int64 temp_command = 0x0000000000000000;
    unsigned __int64 prefix = 0x3FFF; // 14 1 bits as in the preamble of the data packet
    unsigned int error = 0x00; // error byte
    //calculate error detection byte with xor
    error = address ^ inst;
    // combine packet bits in basic DCC format
    command = (prefix<<28)|(address<<19)|(inst<<10)|((error)<<1)|0x01;

    int i = 0;

    // repeat DCC command lots of times
     while(i < repeat_count) {
        temp_command = command;

    //loops throught packet bits enconding and sending out digital pulses for a DCC command
        for (int j=0; j<64; j++) {
            if((temp_command&0x8000000000000000)==0) { //test packet bit

                Track=0;
                wait_us(100);
                Track=1;
                wait_us(100);

            } else {

                Track=0;
                wait_us(58);
                Track=1;
                wait_us(58);

            }

            temp_command = temp_command<<1;
        }
        i++;
    }
}

unsigned __int64 create_instruction(){
    unsigned __int64 instruction = 0x0;
    unsigned __int64 direction = FORWARD;
    unsigned __int64 lights = LIGHTON;
    unsigned __int64 speed = NORM;   
    
    return instruction = (0x01<<6)|(direction<<5)|(lights<<4)|speed;
}

int main(){
    initialize_mcp();
    unsigned __int64 instruction = 0x0;  
     
    while(1){  
        if(interrupted){
            uint16_t data = (mcpReadReg(addr0, MCP_GPIOB) << 8) | mcpReadReg(addr0, MCP_GPIOA); 
            //mcpReadReg(addr0, MCP_INTCAPA);
            //mcpReadReg(addr0, MCP_INTCAPB);
            //modify instructions
            printf("%x interrupted\n", data);
            interrupted = 0; 
        }
        
        instruction = (0x01<<6)|(FORWARD<<5)|(LIGHTON<<4)|FAST;
        DCC_send_command(train3, instruction, def_repeat_count);
    }
}

/*
Interrupts
INT0 - pin 8

clock en data pins for I2C communication - data sync - hier lezen na een interrupt
SDA - pin 9
SCL - pin 10

Sending command signals to train tracks
DAT - pin 20
EN - VOUT


        instruction = (0x01<<6)|(FORWARD<<5)|(LIGHTON<<4)|STOP;
        DCC_send_command(train3, instruction, def_repeat_count);
*/
