#include "mbed.h"
#include "MCP23017.h"

const unsigned __int64 FORWARD = 1;
const unsigned __int64 BACKWARD = 0;
const unsigned __int64 LIGHTON = 1;
const unsigned __int64 LIGHTOFF = 0;
const unsigned __int64 SLOW = 0x4; //0100 = step 5
const unsigned __int64 NORM = 0x9; //1001 = step 15
const unsigned __int64 FAST = 0xE; //1110 = step 25
const unsigned __int64 STOP = 0x1; //0001 = E-STOP

const unsigned __int64 train1 = 0x1; 
const unsigned __int64 train3 = 0x3;
const unsigned __int64 def_repeat_count = 5;

int interrupted = 0;
    
DigitalOut Track(p20);
DigitalOut led(LED1);
InterruptIn int0(p8);
InterruptIn int1(p9);
MCP23017 *mcp;

void initialize_mcp() {
    mcp = new MCP23017(p28, p27, 0x40);  // Connect to mbed int pins 27 and 28,
                                        // MCP address is 0x40
    mcp->reset();
    mcp->writeRegister(0x00, (unsigned char )0xff);
    mcp->writeRegister(0x01, (unsigned char )0xff);
    mcp->writeRegister(0x02, (unsigned char )0x00);
    mcp->writeRegister(0x03, (unsigned char )0x00);
    mcp->writeRegister(0x04, (unsigned char )0xff);
    mcp->writeRegister(0x05, (unsigned char )0xff);
    mcp->writeRegister(0x06, (unsigned char )0xff); 
    mcp->writeRegister(0x07, (unsigned char )0xff);
    mcp->writeRegister(0x08, (unsigned char )0xff);
    mcp->writeRegister(0x09, (unsigned char )0xff);
    mcp->writeRegister(0x0a, (unsigned char )0x42);
    mcp->writeRegister(0x0b, (unsigned char )0x42);
    mcp->writeRegister(0x0c, (unsigned char )0x00);
    mcp->writeRegister(0x0d, (unsigned char )0x00);
    
    wait_ms(100);
    mcp->readRegister(GPIO);
}

void DCC_send_command(unsigned int address, unsigned int inst, unsigned int repeat_count){
    unsigned __int64 command = 0x0000000000000000; // this is a 64-bit integer type, due to the packet size
    unsigned __int64 temp_command = 0x0000000000000000;
    unsigned __int64 prefix = 0x3FFF; // 14 1 bits as in the preamble of the data packet
    unsigned int error = 0x00; // error byte
    //calculate error detection byte with xor
    error = address ^ inst;
    // combine packet bits in basic DCC format
    command = (prefix<<28)|(address<<19)|(inst<<10)|((error)<<1)|0x01;

    int i = 0;

    // repeat DCC command lots of times
     while(i < repeat_count) {
        temp_command = command;

    //loops throught packet bits enconding and sending out digital pulses for a DCC command
        for (int j=0; j<64; j++) {
            if((temp_command&0x8000000000000000)==0) { //test packet bit

                Track=0;
                wait_us(100);
                Track=1;
                wait_us(100);

            } else {

                Track=0;
                wait_us(58);
                Track=1;
                wait_us(58);

            }

            temp_command = temp_command<<1;
        }
        i++;
    }
}

unsigned __int64 create_instruction(){
    unsigned __int64 instruction = 0x0;
    unsigned __int64 direction = FORWARD;
    unsigned __int64 lights = LIGHTON;
    unsigned __int64 speed = NORM;   
    
    return instruction = (0x01<<6)|(direction<<5)|(lights<<4)|speed;
}

void interrupt_handler(){
     interrupted = 1;
}

int main(){
    initialize_mcp();
    int0.fall(&interrupt_handler);
    int1.fall(&interrupt_handler);
    unsigned __int64 instruction = 0x0;  
     
    while(1){    
        if(interrupted){
            printf("interrupted\n");
            mcp->readRegister(INTCAP);
            int data = mcp->readRegister(GPIO); // value of GPIO is 0x12 
            //modify instructions
            printf("%d", data);
            led = 1; 
            interrupted = 0; 
        } else {
            led = 0;
        }
        instruction = (0x01<<6)|(FORWARD<<5)|(LIGHTON<<4)|NORM;
        DCC_send_command(train3, instruction, def_repeat_count);
    }
}

/*
Interrupts
INT0 - pin 8

clock en data pins for I2C communication - data sync - hier lezen na een interrupt
SDA - pin 9
SCL - pin 10

Sending command signals to train tracks
DAT - pin 20
EN - VOUT


        instruction = (0x01<<6)|(FORWARD<<5)|(LIGHTON<<4)|STOP;
        DCC_send_command(train3, instruction, def_repeat_count);
*/
