#include "mbed.h"

const unsigned __int64 FORWARD = 1;
const unsigned __int64 BACKWARD = 0;
const unsigned __int64 LIGHTON = 1;
const unsigned __int64 LIGHTOFF = 0;
const unsigned __int64 SLOW = 0x4; //0100 = step 5
const unsigned __int64 NORM = 0x9; //1001 = step 15
const unsigned __int64 FAST = 0xE; //1110 = step 25
const unsigned __int64 STOP = 0x1; //0001 = E-STOP

DigitalOut Track(p20);
DigitalIn sign2(p14);
DigitalIn sign21(p15);
DigitalIn sign22(p13);
DigitalOut buzz(p21);

void DCC_send_command(unsigned int address, unsigned int inst, unsigned int repeat_count){

    unsigned __int64 command = 0x0000000000000000; // this is a 64-bit integer type, due to the packet size
    unsigned __int64 temp_command = 0x0000000000000000;
    unsigned __int64 prefix = 0x3FFF; // 14 1 bits as in the preamble of the data packet
    unsigned int error = 0x00; // error byte
    //calculate error detection byte with xor
    error = address ^ inst;
    // combine packet bits in basic DCC format
    command = (prefix<<28)|(address<<19)|(inst<<10)|((error)<<1)|0x01;

    int i = 0;

    // repeat DCC command lots of times
     while(i < repeat_count) {
        temp_command = command;

    //loops throught packet bits enconding and sending out digital pulses for a DCC command
        for (int j=0; j<64; j++) {
            if((temp_command&0x8000000000000000)==0) { //test packet bit

                Track=0;
                wait_us(100);
                Track=1;
                wait_us(100);

            } else {

                Track=0;
                wait_us(58);
                Track=1;
                wait_us(58);

            }

            temp_command = temp_command<<1;
        }
        i++;
    }
}

unsigned __int64 create_instruction(){
    unsigned __int64 instruction = 0x0;
    unsigned __int64 direction = FORWARD;
    unsigned __int64 lights = LIGHTON;
    unsigned __int64 speed = NORM;   
    
    return instruction = (0x01<<6)|(direction<<5)|(lights<<4)|speed;
}

int main(){
    unsigned __int64 train1 = 0x1; 
    unsigned __int64 train3 = 0x3;
    unsigned __int64 def_repeat_count = 2;
    unsigned __int64 instruction = 0x0;
    buzz = 0;
    
    while(1){        
        if(sign21){
            instruction = (0x01<<6)|(FORWARD<<5)|(LIGHTOFF<<4)|SLOW;
            buzz = 1;
            DCC_send_command(train3, instruction, def_repeat_count);
        } else if (sign2){
            instruction = (0x01<<6)|(FORWARD<<5)|(LIGHTOFF<<4)|STOP;
            buzz = 1;
            DCC_send_command(train3, instruction, def_repeat_count);
            wait(3);
            
            instruction = (0x01<<6)|(FORWARD<<5)|(LIGHTOFF<<4)|SLOW;
            DCC_send_command(train3, instruction, def_repeat_count*20);
            
        } else if(sign22){
            instruction = (0x01<<6)|(FORWARD<<5)|(LIGHTOFF<<4)|SLOW;
            buzz = 1;
            DCC_send_command(train3, instruction, def_repeat_count);
        } else { 
            instruction = (0x01<<6)|(FORWARD<<5)|(LIGHTON<<4)|FAST;
            buzz = 0;
            DCC_send_command(train3, instruction, def_repeat_count);
        }
    }
}