#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "TextLCD.h"
#include "PinDetect.h"
#include "Speaker.h"
#include <vector>
#include <string>

//Set up LEDs
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

using namespace std;

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
TextLCD lcd(p9, p10, p11, p12, p13, p14); // rs, e, d4-d7
DigitalIn sdDetect(p17); // Set up a pin for SD Card Detect

PinDetect pb1(p28); // pb forup shift
PinDetect pb2(p29); // pb fordown shift
PinDetect pb3(p30); // pb for pause
PinDetect pb4(p27); // pb for volume or play


AnalogOut DACout(p18); //set up speaker
wave_player waver(&DACout); //set up wave player library
int pos = 0; // index of the song
int vol = 0; // volume controller
 
bool playing = false; //variable for pause/play since we only have 1 pb for that
vector<string> filenames; //filenames are stored in a vector string
void read_file_names(char *dir) // function that reads in file names from sd cards
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
}
//interrupt handler for pb1 
void pb1_hit_callback (void)
{
    // it checks for the total number of songs in the sd card..then increments the index until it reaches the last one, then resets to 0
    int l = filenames.size();
    if (pos < (l-1)) {
        pos++;
    } else if (pos == (l-1)) {
        pos = 0;
    }
    string songname = filenames[pos];
    unsigned index = songname.find(".wav");
    songname = songname.substr(0,index);
    lcd.cls();
    lcd.printf(songname.c_str()); //it clears screen and then sets the new index song in the lcd display
}
//interrupt handler for pb2
void pb2_hit_callback (void)
{
    //does opposite of pb1..moves the index down..from 2nd song to 1st song via changing the index number and then calling in the vector
    int l = filenames.size();
    if (pos > 0) {
        pos--;
    } else if (pos == 0 ) {
        pos = l-1;
    }
    string songname = filenames[pos];
    unsigned index = songname.find(".wav");
    songname = songname.substr(0,index);
    lcd.cls();
    lcd.printf(songname.c_str());
}
//interrupt handler for 3rd pushbutton
void pb3_hit_callback (void)
{
    //this interrupt handler changes the play to pause mode or vice versa
    //this is done using the boolean playing
    if (playing == false) {
        playing = true; 
    } else if (playing == true) {
        lcd.cls();
        playing = false; 
        string songname = filenames[pos];
        unsigned index = songname.find(".wav");
        songname = songname.substr(0,index);
        lcd.printf(songname.c_str());
    }
}
//interrupt handler for pb4
void pb4_hit_callback (void){
    // this pb changes the volume by lowering the volume until it reaches 0. then it resets to the max volume
    // the volume range has been divided into 16 possible ranges. and hence, it toggles through those 16 values
    // this only changes the variable vol, which is then used in the wave player file to actually adjust the volume
    vol = (vol+1) % 16;
}

int main()
{
    sdDetect.mode(PullUp);
     wait(.1);
     //wait after pulling up the sd card, 
    // read file names into vector of strings
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb4.attach_deasserted(&pb4_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    pb4.setSampleFrequency();
    lcd.cls();
    //detects whethere there is a SD card or not.. if not then it prints and informs the user
    while(sdDetect ==0) {
        lcd.locate(0,0);
        lcd.printf("Insert SD Card");
        wait(.5);
    }    
    lcd.cls(); 
    wait(.5);
    sd.disk_initialize();
    read_file_names("/sd/Music");
    while(1) {
        //while pb3 is low, then we can start playing the song
        while(playing == true) { //we have 2 while loops..one while loop makes sure the music player is always on, the other one is for the song
            string songname = filenames[pos];
            string a = "/sd/Music/";
            string fname = a + songname; //retrieves the file name
            FILE *wave_file; 
            lcd.locate(0,1);
            lcd.printf("Now Playing");
            wave_file = fopen(fname.c_str(),"r"); //opens the music file
            waver.play(wave_file); //plays the music file
            fclose(wave_file);
        }
    }
}
