#include "mbed.h"
#include "FATFileSystem.h"
#include "SDBlockDevice.h"
#include <stdio.h>
#include <errno.h>
#include "freetronicsLCDShield.h"
/* Helper header files. */
#include "DevI2C.h"

/* Component specific header files. */
#include "STA350BW.h"

/* My song header file. */
#include "my_song.h"

//SDBlockDevice bd(PB_5, PB_4, PB_3, PA_15);
SDBlockDevice bd(PA_7, PA_6, PA_5, PA_8);
FATFileSystem fs("fs");
freetronicsLCDShield lcd(D8, D9, D4, D5, D6, D2, D3, A0);
Thread Leggi_SD_Thread;
Thread Suona_Thread;
argomento* arg=(argomento*) malloc(sizeof(argomento));

Mutex mutex_ping;

Semaphore SPAZIO_DISP(2);
Semaphore MSG_DISP(2);

void Leggi_SD(argomento * arg){
    
    while(1){
        mutex_ping.lock();
        SPAZIO_DISP.wait();
        if ( arg->ping_r==0){

        fread(arg->ping,sizeof(int16_t), arg->size, arg->fd);
        arg->ping_r=1;
                //printf(" caricato ping\r\n");

        }else if( arg->pong_r==0){
                
                fread(arg->pong,sizeof(int16_t), arg->size, arg->fd);
                arg->pong_r=1;
                        }
                        
        MSG_DISP.release();
        mutex_ping.unlock();
                        
       // printf(" caricato ping\r\n");
/*
        
                            arg->mutex_pong.lock();

        fread(arg->pong, sizeof(int16_t), arg->size, arg->fd);
                arg->pong_r=1;
                arg->mutex_pong.unlock();
                printf(" caricato pong\r\n");        

          
            arg->sel=!(arg->sel);
            */
        }  
    
    }



#define PLAY_STOP_EVENT      (0x1)
 int16_t buff[3000] = {0};

/* Variables -----------------------------------------------------------------*/

/* Initialization parameters. */
STA350BW_init_t init =
{
    22000,   /* Default Sampling Frequency [Hz]. */
    100      /* Default Volume. */
};

/* Sound Terminal Component. */
STA350BW *sound_terminal;

/* Thread to manage I2S peripherals. */
static rtos::Thread i2s_bh_daemon;

/* Threads. */
Thread *play_stop_thread;

/* User button handling. */
InterruptIn event(USER_BUTTON);


/* Functions -----------------------------------------------------------------*/

/**
 * @brief  User button handler function.
 * @param  None.
 * @retval None.
 */
void pressed(void)
{
    /* Signal to play/stop handler thread. */
    play_stop_thread->signal_set(PLAY_STOP_EVENT);
}

/**
 * @brief  Play/stop handler function.
 * @param  None.
 * @retval None.
 */
 
void play_stop_handler(void)
{
    while (true)
    {
        static bool stop = true;

        // Waiting for play/stop events. 
        play_stop_thread->signal_wait(PLAY_STOP_EVENT);

        if (stop)
            sound_terminal->stop();
        else
          //  sound_terminal->play((int16_t *) my_song, (uint16_t) sizeof(my_song), true);
        printf("--> %s\r\n", stop ? "Stop." : "Playing...");

        stop = !stop;
    }
}    
    

void return_error(int ret_val){
  if (ret_val)
    printf("Failure. %d\r\n", ret_val);
  else
    printf("done.\r\n");
}

void errno_error(void* ret_val){
  if (ret_val == NULL)
    printf(" Failure. %d \r\n", errno);
  else
    printf(" done.\r\n");
}

void Suona(argomento * arg){
        
        while(1){    
                    mutex_ping.lock();
                    MSG_DISP.wait();
if(arg->ping_r==1){
            sound_terminal->play((int16_t *) arg->ping, (uint16_t) sizeof(int16_t)*(arg->size), false);
                 // printf(" suonato ping\r\n");
                arg->ping_r=0;
}
 if(arg->pong_r==1){
    
    sound_terminal->play((int16_t *) arg->pong, (uint16_t) sizeof(int16_t)*(arg->size), false);
                 // printf(" suonato ping\r\n");
                arg->pong_r=0;
    }
    
    mutex_ping.unlock();
    SPAZIO_DISP.release();
        }
    }

int main() {
      
       /*----- Initialization. -----*/
//arg->sel=0;
arg->size=9000;
     arg->ping_r=0;
     arg->pong_r=0;

    /* Initializing I2C bus. */
    DevI2C *dev_i2c = new DevI2C(PB_9, PB_8);

    /* Initializing Sound Terminal Component. */
#ifndef USE_I2S2
    sound_terminal = new STA350BW(PA_10, STA350BW_ADDRESS_1, *dev_i2c, PB_15, PB_13, PB_12, NC, PC_6);
#else
    sound_terminal = new STA350BW(PA_10, STA350BW_ADDRESS_2, *dev_i2c, PC_12, PC_10, PA_4, NC, PC_7);
#endif
    if (sound_terminal->init(&init) != COMPONENT_OK)
    {
        error("Initialization of the Sound Terminal Expansion Board failed.\r\n");
        exit(EXIT_FAILURE);
    }

    /* Starting a thread to manage I2S peripherals. */
    Callback<void()> i2s_bh_task(&I2S::i2s_bh_queue, &events::EventQueue::dispatch_forever);
    i2s_bh_daemon.start(i2s_bh_task);

    /* Scheduling the play/stop function. */
    play_stop_thread = new Thread();
    osStatus status = play_stop_thread->start(play_stop_handler);
    if (status != osOK)
        printf("Could not start the play/stop handler thread.\r\n");
    event.fall(&pressed);

    /* Setting Sound Terminal Component's parameters. */
    sound_terminal->set_frequency(MY_SONG_AUDIO_FREQUENCY);
    sound_terminal->set_volume(STA350BW_CHANNEL_MASTER, 55);

    /* Printing to the console. */
    printf("Sound Terminal Application Example\r\n\n");

      
      
      
      
      
      
      
      
      
      // turn on the back light (it's off by default)
  lcd.setBackLight(true);
  
  int error = 0;
  printf("Welcome to the filesystem example.\r\n"
         "Formatting a FAT, RAM-backed filesystem. ");
  //error = FATFileSystem::format(&bd);
  return_error(error);

  printf("Mounting the filesystem on \"/fs\". ");
  error = fs.mount(&bd);
  return_error(error);


  printf(" done.\r\n");

  printf("Re-opening file read-only.");
 FILE* fd = fopen("/fs/marcia.wav", "r");
  errno_error(fd);
  arg->fd=fd;
   Leggi_SD_Thread.start(callback(Leggi_SD,arg));
    Suona_Thread.start(callback(Suona,arg));
    

  printf("Dumping file to screen.\r\n");
 
  while (!feof(fd)){
     
     // printf("inizo file to screen.\r\n");
//fscanf( fd , "%c%c" , & a ) ;
//fscanf( fd , "%c" , & c) ;
//fread(buff,sizeof(int16_t),3000,fd);
//int b=(((int)a*256)+((int )c));
//b=b-32768;
//printf("%d \r\n",b);
//printf ( "%c-" , a[1]) ;printf ( "%c\r\n" , a[0]) ;
//printf("--> Playing...\r\n");
//printf ( "%d\r\n " , buff[i] ) ;

    //buff[i]=a;
    
    

   // int size = fread(&buff[0], 1, 159, fd);
    //fwrite(&buff[0], 1, size, stdout);
    
     //sound_terminal->play((int16_t *) buff, (uint16_t) sizeof(buff), true );
  }
  printf("EOF.\r\n");

  printf("Closing file.");
  fclose(fd);
  printf(" done.\r\n");

  printf("Opening root directory.");
  DIR* dir = opendir("/fs/");
  errno_error(fd);

  struct dirent* de;
  printf("Printing all filenames:\r\n");
  while((de = readdir(dir)) != NULL){
    printf("  %s\r\n", &(de->d_name)[0]);
  }

  printf("Closeing root directory. ");
  error = closedir(dir);
  return_error(error);
  printf("Filesystem Demo complete.\r\n");

  while (true) {}
}