#include "mbed.h"
#include "rtos.h"
#include "Serial.h"
#include "BufferedSerial.h"
#include "Communication.h"
#include "Motor.h"
#include <stdlib.h>
#include <stdio.h>
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"


//Dichiarazione oggetti
DigitalIn myStopButton(USER_BUTTON);
Motor lid_Motor(PWM_OUT);
Communication SendCommands;
LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
LCD_DISCO_F746NG lcd_Thread;

//Dichiarazione variabili
TS_StateTypeDef TS_State;

uint16_t x,y;
uint8_t idx;
uint8_t start=1;

void StopLidar_thread(void const *args) {
    wait(1);
    while(true) {
         if (myStopButton==1) {
                SendCommands.Stop();
                wait_ms(10);
                lid_Motor.StopMotor_Scan();
                wait_ms(10);
                SendCommands.Reset();
                wait_ms(10);
                lcd_Thread.DisplayOff();
        }
     }
}


int main() {
//  Threads start here
    Thread StopLidar__th(StopLidar_thread);
    
//  Initialize Display
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    wait(0.3);
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"SLAMTEC LIDAR A2", CENTER_MODE);
    lcd.SetFont(&Font8);
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"STMicroelectronics", RIGHT_MODE);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"D. Ruggiero 2016", RIGHT_MODE);

//  Configure buttons and TFT display
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.FillRect(136, 200, 200, 50);  ///Disegna bottone Verde

    lcd.SetFont(&Font24);
    lcd.SetBackColor(LCD_COLOR_GREEN);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(202, LINE(9), (uint8_t *)"SCAN", LEFT_MODE);

  while(start) {
      
//    Initialize TFT display
      ts.GetState(&TS_State);
      if (TS_State.touchDetected) {
          for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
          }

     if((x>=136) && (x<=336) && (y>=200) && (y<=250)) {    
     lcd.Clear(LCD_COLOR_BLACK);

//   Initialize UART
     SendCommands.confUART();

  // Perform a device reset
//   SendCommands.Reset();

  // Send Get_Health command
//   SendCommands.Get_Health();

  // Send Get_Info command
//   SendCommands.Get_Info();

  // Start motor (PWM: Frequency 25KHz, Duty cycle 60%)
     lid_Motor.StartMotor_Scan();
     
//   Start scan
     SendCommands.Scan();
     start=0;
        }
    }
 }
   
}


