#include "mbed.h"
#include "math.h"
#include "DigitalInOut.h"
/* Como el movimiento de los motores lo hace el arduino y las medidas la stm32 tienen que coordinarse de alguna manera
   Este codigo tiene que hacer las medidas cuando le llegue un 1 por el puerto digital input 13 ,significa q los motores ya estan en posición
   Cuando acabe de medir, enviar un 1 por el puerto digital output 12 , le dice al arduino q ha acabado y tiene q cambiar la posición

*/
AnalogIn top_left(A0); // Analog InPut
AnalogIn top_right(A1); // Analog InPut
AnalogIn bot_left(A2); // Analog InPut
AnalogIn bot_right(A3); // Analog InPut
//Para coordinar el arduino y el stm32 utilizamos dos pines digitales de mas 
//pin 13: si 0 arduino se esta moviendo no tomar medidas, si 1 arduino en posicion empezar a tomar medidas
//pin 12: si 0 aun se esta midiendo no mover, si 1 medidas acabadas arduino ya se puede mover 
DigitalInOut medir(D6); //si llega 1=high el arduino ya esta en posicion y ya se puede medir
DigitalInOut mover(D5); // ya hemos medido, decimos al arduino q cambie la posicion, enviar 1=high
DigitalInOut end(D4); //calibracion acabada


const int N =100; //Number of measures x position


DigitalOut myled(LED1); // Digital OutPut
Serial pc(SERIAL_TX, SERIAL_RX); // Default USART is: 8N1 NO FlowControl


// Variables --------------------------------------------------------------
uint16_t measTL = 0;
uint16_t measTR = 0;
uint16_t measBL = 0;
uint16_t measBR = 0;
int j=0; //iterator 1

int mitja_esquerra_adalt= 0; //Average of measures of PH
int mitja_dreta_adalt=0;     //Average of measures of PH
int mitja_esquerra_abaix=0;  //Average of measures of PH
int mitja_dreta_abaix = 0;   //Average of measures of PH

int val_top_left [N]= {0};  //instantaneous value of measure of PH
int val_top_right [N]= {0}; //instantaneous value of measure of PH
int val_bot_left [N]= {0};  //instantaneous value of measure of PH
int val_bot_right [N]= {0}; //instantaneous value of measure of PH

double sum_top_left= 0;  //sumatory of measures of PH
double sum_top_right= 0; //sumatory of measures of PH
double sum_bot_left= 0;  //sumatory of measures of PH
double sum_bot_right= 0; //sumatory of measures of PH

double sum_var_top_left=0;
double sum_var_top_right=0;
double sum_var_bot_left=0;
double sum_var_bot_right=0;

int val_var_top_left=0;     //Variance Value for this PH
int val_var_top_right=0;    //Variance Value for this PH
int val_var_bot_left=0;     //Variance Value for this PH
int val_var_bot_right=0;    //Variance Value for this PH
char c;
char checker;




//DigitalOut led(LED1);


// ATTENTION
// The two value below, must be changed in according to the Vcc and ADC
// resolution
float_t Valim = 3300; // This is the supplay voltage of ADC (or MCU)
float_t ADCres = 4096; // This is the ADC resolution that in this case si 12Bit
// All NUCLEO boards use an ADC with 12bit resolution

int main()
{
    
    pc.printf("\n\r\n\rSTART program\n\r");
    pc.printf("\n mitja_esquerra_adalt , var_top_left , mitja_dreta_adalt , var_top_right , mitja_esquerra_abaix , var_bot_left , mitja_dreta_abaix , var_bot_right\n");
    end.write(0);
    checker='2';
    c='0';
    while(1) {

        //mientras no este en la posicion, el arduino se esta moviendo, no se puede medir, se espera
        c=pc.getc();
        while(c=='0'){
            c=pc.getc();
            pc.printf("%c",c);
        }

        //cuando esta en posicion, medir
        if(c!='0'){
            sum_top_left=0;
            sum_top_right=0;
            sum_bot_left=0;
            sum_bot_right=0;

            sum_var_top_left=0;
            sum_var_top_right=0;
            sum_var_bot_left=0;
            sum_var_bot_right=0;

            while(j<N) {
                val_top_left[j]=top_left.read_u16();    //Taking N measures
                val_top_right[j]=top_right.read_u16();  //Taking N measures
                val_bot_left[j]=bot_left.read_u16();    //Taking N measures
                val_bot_right[j]=bot_right.read_u16();  //Taking N measures



                sum_top_left = sum_top_left + val_top_left[j];      //Making the sum of the measure for each PH
                sum_top_right = sum_top_right + val_top_right[j];   //Making the sum of the measure for each PH
                sum_bot_left = sum_bot_left + val_bot_left[j];      //Making the sum of the measure for each PH
                sum_bot_right = sum_bot_right + val_bot_right[j];   //Making the sum of the measure for each PH

                j++;

            }

            mitja_esquerra_adalt=double(rint((sum_top_left/N))); //Computiong the average
            mitja_dreta_adalt=double(rint((sum_top_right/N)));   //Computiong the average
            mitja_esquerra_abaix=double(rint((sum_bot_left/N))); //Computiong the average
            mitja_dreta_abaix=double(rint((sum_bot_right/N)));   //Computiong the average

            for (j=0; j<N; j++) {
                sum_var_top_left= ((val_top_left[j]-mitja_esquerra_adalt)*(val_top_left[j]-mitja_esquerra_adalt)) + sum_var_top_left;   //Variance for each measure
                sum_var_top_right= ((val_top_right[j]-mitja_dreta_adalt)*(val_top_right[j]-mitja_dreta_adalt)) + sum_var_top_right;     //Variance for each measure
                sum_var_bot_left= ((val_bot_left[j]-mitja_esquerra_abaix)*(val_bot_left[j]-mitja_esquerra_abaix)) + sum_var_bot_left;   //Variance for each measure
                sum_var_bot_right= ((val_bot_right[j]-mitja_dreta_abaix)*(val_bot_right[j]-mitja_dreta_abaix)) + sum_var_bot_right;     //Variance for each measure

            }
            val_var_top_left=double(rint(sqrt(sum_var_top_left/N)));    //Obtaining Variance Value for this PH
            val_var_top_right=double(rint(sqrt(sum_var_top_right/N)));  //Obtaining Variance Value for this PH
            val_var_bot_left=double(rint(sqrt(sum_var_bot_left/N)));    //Obtaining Variance Value for this PH
            val_var_bot_right=double(rint(sqrt(sum_var_bot_right/N)));  //Obtaining Variance Value for this PH


            //PRINTEJAR RESULTATS
            //pc.printf("\n%d ,", mitja_esquerra_adalt);
            //pc.printf(" %d ,", val_var_top_left);
            //pc.printf(" %d ,", mitja_dreta_adalt);
            //pc.printf(" %d ,", val_var_top_right);
            //pc.printf(" %d ,", mitja_esquerra_abaix);
            //pc.printf(" %d ,", val_var_bot_left);
            //pc.printf(" %d ,", mitja_dreta_abaix);
            //pc.printf(" %d ,", val_var_bot_right);
            
            
        }
        c='0';
        pc.printf("Measures finished\n");
        wait_ms(1000); //esperar por si acaso
        //para asegurar que la stm se espere hasta que cambien la posicion

    }
}
    