#include "mbed.h"
#include <MLX90640_I2C_Driver.h>
#include <MLX90640_API.h>

#define FRAMES_NUM 15
#define TA_SHIFT 8

#define FIRMWARE "eye_r_eye-mlx90640_32x24-v_1_5"
Serial pc(USBTX, USBRX);                                                        // tx, rx, Virtual serial port over USB
void PrintEEPROM(uint16_t *p);
void PrintRawData(uint16_t *p);
void PrintToF(float *p);
void PrintToU(float *p);

DigitalOut led_green(LED2);

char buffer[3076]={'S'};

int main()
{
    uint8_t printme=1;
    MLX90640_I2CFreqSet(1000);
    pc.baud(230400);
    paramsMLX90640 mlx90640;
    uint8_t slaveAddress = 0x33;
    uint16_t *pEE;
    uint16_t *pFrame;
    static uint16_t eeMLX90640[832];
    static uint16_t mlx90640Frame[834];
    static float mlx90640To[768];
    float emissivity = 1;
    float eTa;                      //Ta for emissivity compensation

    pEE = eeMLX90640;
    pFrame = mlx90640Frame;
    MLX90640_SetRefreshRate(slaveAddress,1);
    //MLX90640_SetResolution(slaveAddress,0x03);
    MLX90640_SetInterleavedMode(slaveAddress);
    MLX90640_I2CFreqSet(400);
    MLX90640_DumpEE(slaveAddress, pEE);
    MLX90640_I2CFreqSet(1000);
    MLX90640_ExtractParameters(pEE, &mlx90640 );

    while (1) 
    {
        if (pc.readable())
        {
            char c = pc.getc();
            if (printme)
            {
                switch (c)
                {
                    case 'q':
                        printme=0;
                        break;
                }
                continue;
            }
            
            switch (c)
            {
                case '1':
                    MLX90640_SetRefreshRate(slaveAddress,1);
                    break;
                    
                case '2':
                    MLX90640_SetRefreshRate(slaveAddress,2);
                    break;
                    
                case '4':
                    MLX90640_SetRefreshRate(slaveAddress,4);
                    break;
                    
                case '5':
                    MLX90640_SetRefreshRate(slaveAddress,5);
                    break;
                    
                case 'c':
                    MLX90640_SetChessMode(slaveAddress);                
                    break;
                    
                case 'i':
                    MLX90640_SetInterleavedMode(slaveAddress);
                    break;
                   
                case '?':
                    pc.printf(FIRMWARE "\n");
                    break;                    
                    
                case 'p':
                    printme=1;
                    break;                    
                    
                default:
                    pc.printf("?\n");
                    break;                    
                        
            } // switch
        }

        led_green = 1;    // turn on LED until initialization is complete
        MLX90640_GetFrameData(slaveAddress, pFrame);
        led_green = 0;    // turn on LED until initialization is complete
        eTa = MLX90640_GetTa(pFrame, &mlx90640) - TA_SHIFT;
        MLX90640_CalculateTo(pFrame, &mlx90640, emissivity, eTa, mlx90640To);
        if (printme)
        {            
            PrintToU(mlx90640To);
        }
    }

}

void PrintToU(float *p)
{
    uint16_t idx=1,i;
    uint16_t d;    
    for(i=0; i<768; i++) 
    {
        d = 10 * *p++;
        sprintf(buffer+idx,"%04x",d);
        idx+=4;
    }
    buffer[idx++] = 'E';
    buffer[idx++] = '\n';
    buffer[idx++] = 0;
    pc.printf(buffer);
}

void PrintToF(float *p)
{
    for(int i=0; i<768; i++) 
    {
        pc.printf("%0.3f,",*p++);
    }
    pc.printf("\n");

}

void PrintRawData(uint16_t *p)
{
    for(int i=0; i<832; i++) {
        pc.printf("%04X,",*p++);
    }
    pc.printf("\r\n");
}
