#include "mbed.h"
#include "MLX90640_I2C_Driver.h"


//int * I2CReadMLX90640(int,int,int);
I2C i2c(PB_7, PB_6);

void MLX90640_I2CInit()
{   
    i2c.stop();
}

int MLX90640_I2CRead_working(uint8_t slaveAddr, uint16_t startAddress, uint16_t nWordsRead, uint16_t *data)
{
    uint8_t sa;                           
    int cnt = 0;
    int i = 0;
    char cmd[2] = {0,0};
    char i2cData[1664] = {0};
    uint16_t *p;
    
    p = data;
    sa = (slaveAddr << 1);
    cmd[0] = startAddress >> 8;
    cmd[1] = startAddress & 0x00FF;
    
    wait_us(5);    
    if (i2c.write(sa, cmd, 2, 1))
    {
        return -1;
    }
             
    sa = sa | 0x01;
    if (i2c.read(sa, i2cData, 2*nWordsRead, 0))
    {
        return -1; 
    }          
    //i2c.stop();   
    
    for(cnt=0; cnt < nWordsRead; cnt++)
    {
        i = cnt << 1;
        *p++ = (uint16_t)i2cData[i]*256 + (uint16_t)i2cData[i+1];
    }
    
    return 0;   
} 

int MLX90640_I2CRead(uint8_t slaveAddr, uint16_t startAddress, uint16_t nWordsRead, uint16_t *data)
{
    uint8_t sa;                           
    uint16_t cnt = 0;
    char *i2cData = (char *) data;
    
    sa = (slaveAddr << 1);
    startAddress = __REV16(startAddress);
    
    wait_us(5);    
    if (i2c.write(sa, (char *) &startAddress, 2, 1))
    {
        return -1;
    }
             
    sa = sa | 0x01;
    if (i2c.read(sa, i2cData, nWordsRead<<1, 0))
    {
        return -1; 
    }          
    
    for(cnt=0; cnt < nWordsRead; cnt++)
    {
        data[cnt] = __REV16(data[cnt]);
    }
    
    return 0;   
} 

void MLX90640_I2CFreqSet(int freq)
{
    i2c.frequency(1000*freq);
}

int MLX90640_I2CWrite(uint8_t slaveAddr, unsigned int writeAddress, uint16_t data)
{
    uint8_t sa;
    int ack = 0;
    char cmd[4] = {0,0,0,0};
    static uint16_t dataCheck;
    

    sa = (slaveAddr << 1);
    cmd[0] = writeAddress >> 8;
    cmd[1] = writeAddress & 0x00FF;
    cmd[2] = data >> 8;
    cmd[3] = data & 0x00FF;

    //i2c.stop();
    wait_us(5);    
    ack = i2c.write(sa, cmd, 4, 0);
    
    if (ack != 0x00)
    {
        return -1;
    }         
    //i2c.stop();   
    
    MLX90640_I2CRead(slaveAddr,writeAddress,1, &dataCheck);
    
    if ( dataCheck != data)
    {
        return -2;
    }    
    
    return 0;
}


