#include "mbed.h"

/** 
  * HTPA32x32dL2_1HiSiF5_0: TN=96
  */
#include "heimann32x32.h"

#define FIRMWARE "eye_r_eye-v_1_9"

//#define BAUDRATE 115200
#define BAUDRATE 230400
//#define PROC     HTPA_PROC_RAW
#define PROC     (HTPA_PROC_ELOFFS  | HTPA_PROC_THOFFS)
//#define PROC        HTPA_PROC_ELOFFS
//#define PROC     (HTPA_PROC_ELOFFS  | HTPA_PROC_THOFFS | HTPA_PROC_CONVERT)

#define HTPA_DT_MS  5

I2C i2c(I2C_SDA, I2C_SCL), i2ce(I2C_SDA, I2C_SCL);

HTPA32x32 h = HTPA32x32( (I2C  *) &i2c,  (I2C  *) &i2ce);

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut led_green(LED2);

int main()
{
    bool printme=0, print_labels=0;
    uint8_t j;
    int16_t i;
    
    led_green = 1;    // turn on LED until initialization is complete

    pc.baud(BAUDRATE);    

    wait_ms(100);
   
    h.init();       
    wait_ms(HTPA_DT_MS);
    h.PU(1);
    
    h.start();
    h.proc = PROC;
    
    wait_ms(HTPA_DT_MS);

    led_green = 0;    // initializaiton complete

    if (h.tn != TABLENUMBER)
    {
        pc.printf("TN=%d does not match the interpolation table %d\n", h.tn, TABLENUMBER);
        pc.printf("Cannot continue!\n");
        while (1);
    }
        
    while (1)
    {
        /* talk to me! */
        if (pc.readable())
        {
            char c = pc.getc();
            if (printme)
            {
                switch (c)
                {
                    case 'p':
                        printme=1;
                        break;
                    
                    case 'q':
                        printme=0;
                        break;
                }
                continue;
            }

            switch (c)
            {
                case '?':
                    pc.printf(FIRMWARE "\n");
                    break;                    
                
                case 'c':
                    /* complete conversion to dK */
                    h.proc = HTPA_PROC_CONVERT | HTPA_PROC_ELOFFS | HTPA_PROC_THOFFS;
                    break;
                    
                case 'o':
                    /* raw readings compensated by electric and thermal offsets */
                    h.proc = HTPA_PROC_ELOFFS | HTPA_PROC_THOFFS;
                    break;
                
                case 'r':
                    /* raw readings */
                    h.proc = HTPA_PROC_RAW;
                    break;
                    
                case 'd':
                    if (print_labels)
                        pc.printf("adc=", h.mbit);
                    pc.printf("%x,", h.mbit);
                    if (print_labels)
                        pc.printf("bias=");
                    pc.printf("%x,", h.bias);
                    if (print_labels)
                        pc.printf("clk=");
                    pc.printf("%x,", h.clk);
                    if (print_labels)
                        pc.printf("bpa=");
                    pc.printf("%x,", h.bpa);
                    if (print_labels)
                        pc.printf("pu=");
                    pc.printf("%x,", h.pu);
                    if (print_labels)
                        pc.printf("tn=");
                    pc.printf("%x,", h.tn);
                    if (print_labels)
                        pc.printf("PixCmin=");
                    pc.printf("%f,", h.PixCmin);
                    if (print_labels)
                        pc.printf("PixCmax=");
                    pc.printf("%f,", h.PixCmax);
                    if (print_labels)
                        pc.printf("epsilon=");
                    pc.printf("%d,", h.epsilon);
                    if (print_labels)
                        pc.printf("gradScale=");
                    pc.printf("%d,", h.gradScale);
                    if (print_labels)
                        pc.printf("PTATgrad=");
                    pc.printf("%f,", h.PTATgrad);
                    if (print_labels)
                        pc.printf("PTAToffs=");
                    pc.printf("%f\n", h.PTAToffs);
                    break;
                    
                case 't':
                    if (print_labels)
                        pc.printf("Ta_dK=");
                    pc.printf("%d\n", h.Ta_dK);
                    break;

                case 'l':
                    print_labels=1;
                    break;
                
                case 's':
                    print_labels=0;
                    break;                    
                    
                case 'p':
                    printme=1;
                    break;
                    
                case 'q':
                    printme=0;
                    break;
            } // switch
        }

        if (h.eoc())
        {
            led_green = 1;
            h.readb();
            led_green = 0;
            
            if (h.available)
            {
                h.apply_offsets();
                
                if (printme)
                {
                    if (print_labels)
                        pc.printf("data=");                    
                    uint16_t * data_ptr = (uint16_t *) h.Data;
                    for (i=0; i<32; i++) 
                    {
                        for (j=0; j<32; j++)
                        {
                            if (!print_labels)
                            {
                                if (i==0 && j==0)
                                    pc.printf("S%04x", data_ptr[32*i + j]);
                                else
                                    pc.printf("%04x", data_ptr[32*i + j]);
                            }
                            else
                                pc.printf("%04x", data_ptr[32*i + j]);
                        }
                    }
                    if (print_labels)
                        pc.printf("\n");
                    else
                        pc.printf("E\n");
                
                } // if (printme)
                
            } // if (h.available)
        
        } // if (t.read_ms() ... )
        
    } // while(1)

} // main
