#ifndef _I2C_HEIMANN32X32_
#define _I2C_HEIMANN32X32_

#define AdrPixCMin 0x00
#define AdrPixCMax 0x04
#define AdrGradScale 0x08
#define AdrTableNumber 0x0B         //changed to 0x0B with Rev 0.14 and adpated TN readout
#define AdrEpsilon 0x0D

#define AdrMBITPixC 0x1A
#define AdrBIASPixC 0x1B
#define AdrCLKPixC 0x1C
#define AdrBPAPixC 0x1D
#define AdrPUPixC 0x1E

#define AdrVddMeasTh1 0x26
#define AdrVddTh1 0x46

#define AdrPTATGrad 0x34

#define AdrVddScaling 0x4E
#define AdrVddScalingOff 0x4F

#define AdrMBITUser 0x60
#define AdrBIASUser 0x61
#define AdrCLKUser 0x62
#define AdrBPAUser 0x63
#define AdrPUUser 0x64

#define AdrDevID 0x74

#define AdrGlobalOffset 0x54
#define AdrGlobalGain 0x55

#define AdrVddCompValues2 0x340
#define AdrVddCompValues 0x540
#define AdrTh1 0x740
#define AdrTh2 0xF40
#define AdrPixC 0x1740

#define BIAScurrentDefault 0x05
#define CLKTRIMDefault 0x15 //0x20 to let it run with 10 Hz
#define BPATRIMDefault 0x0C
//#define MBITTRIMDefault 0x0C
#define PUTRIMDefault   0x88


//pixelcount etc. for 32x32d
#define Pixel 1024              //=32x32
#define PixelEighth 128
#define LINE 32
#define COLUMN 32
#define DATALength 1292//1098                   //length of first packet
#define DATALength2 1288//1096                  //lenght of second/last packet
#define DataLengthHalf 646
#define PTATamount 8
#define ELOFFSET 1024           //start address of el. Offset
#define ELAMOUNT 256
#define ELAMOUNTHALF 128
#define StackSize 16            //must be choosen by the user!
#define PTATSTARTADSRESS 1282
#define VDDADDRESS 1280

#define GetElEveryFrameX 10     //amount of normal frames to capture after which the el. Offset is fetched
#define STACKSIZEPTAT 30        //should be an even number
#define STACKSIZEVDD 50         //should be an even number
#define VddStackAmount 30


#define ReadToFromTable
#ifdef ReadToFromTable
    #define HTPA32x32dL2_1HiSiF5_0
    //#define HTPA32x32dL2_1HiSiF5_0
    //#define HTPA32x32dL2_1HiSiF5_0_withSiFilter
    //#define HTPA32x32dL3_6HiSi
    //#define HTPA32x32dL3_6HiSi_Rev1
    //#define HTPA32x32dL7_0HiSi
    //#define HTPA32x32dL5_0HiGeF7_7
    //#define HTPA32x32dL1_6HiGe
    //#define HTPA32x32dR1L1_6HiGe_Gain3k3
    //#define HTPA32x32dR1L2_1SiF5_0_N2
    //#define HTPA32x32dL2_1HiSiF5_0_Gain3k3            //is used for SensorRev. 1      
    //#define HTPA32x32dR1L2_1HiSiF5_0_Precise  
    //#define HTPA32x32dR1L2_85Hi_Gain3k3       
    //#define HTPA32x32dR1L3_6HiSi_Rev1_Gain3k3
    //#define HTPA32x32dR1L5_0HiGeF7_7_Gain3k3      
    //#define HTPA32x32dR1L7_0HiSi_Gain3k3

    #ifdef HTPA32x32dL5_0HiGe
        #define TABLENUMBER     79
        #define PCSCALEVAL      100000000 //327000000000        //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  471 //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     512
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif   
    #endif

    #ifdef HTPA32x32dL5_0HiGeF7_7
        #define TABLENUMBER     92
        #define PCSCALEVAL      100000000 //327000000000        //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  471 //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     256
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif   
    #endif
    
    #ifdef HTPA32x32dR1L5_0HiGeF7_7_Gain3k3
        #define TABLENUMBER     113
        #define PCSCALEVAL      100000000 //327000000000        //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  1595    //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     1024
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif   
        #define MBITTRIMDefault 0x2C
        #define SensRv 1
    #endif  

    #ifdef HTPA32x32dL1_6HiGe
        #define TABLENUMBER     101 
        #define PCSCALEVAL      100000000       //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  471     //possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     256
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif   
    #endif
    
    #ifdef HTPA32x32dR1L1_6HiGe_Gain3k3
        #define TABLENUMBER     119
        #define PCSCALEVAL      100000000 //327000000000        //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  1595    //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     1024
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif   
        #define MBITTRIMDefault 0x2C
        #define SensRv 1
    #endif  

    #ifdef HTPA32x32dL2_1HiSi
        #define TABLENUMBER     80
        #define PCSCALEVAL      100000000       //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  471 //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     256
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif
    #endif

    #ifdef HTPA32x32dL2_1HiSiF5_0
        #define TABLENUMBER     96
        #define PCSCALEVAL      100000000       //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  471 //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     256
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif
    #endif
    
    #ifdef HTPA32x32dR1L2_1SiF5_0_N2
        #define TABLENUMBER     130
        #define PCSCALEVAL      100000000 //327000000000        //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  1595    //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     192
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif   
        #define MBITTRIMDefault 0x2C
        #define SensRv 1
    #endif  
    
    #ifdef HTPA32x32dL2_1HiSiF5_0_Gain3k3
        #define TABLENUMBER     114
        #define PCSCALEVAL      100000000 //327000000000        //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  1595    //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     1024
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif   
        #define MBITTRIMDefault 0x2C    //use REF_CAL=2 here. Table does not match, so GlobalGain ist set to 50 % to compensate this.
        #define SensRv 1                //Sensor Revision is set to 1 (Redesign)
    #endif  
    
    #ifdef HTPA32x32dR1L2_1HiSiF5_0_Precise
        #define TABLENUMBER     116
        #define PCSCALEVAL      100000000 //327000000000        //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  22
        #define NROFADELEMENTS  1000    //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  50      //dK
        #define ADEQUIDISTANCE  32      //dig
        #define ADEXPBITS       5       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     1024
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif   
        #define MBITTRIMDefault 0x2C
        #define SensRv 1
    #endif  

    #ifdef HTPA32x32dL2_1HiSiF5_0_withSiFilter
        #define TABLENUMBER     97
        #define PCSCALEVAL      100000000       //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  471 //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     256
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif
    #endif
    
    #ifdef HTPA32x32dR1L2_85Hi_Gain3k3
        #define TABLENUMBER     127
        #define PCSCALEVAL      100000000 //327000000000        //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  1595    //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     1024
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif   
        #define MBITTRIMDefault 0x2C
        #define SensRv 1
    #endif  

    #ifdef HTPA32x32dL3_6HiSi
        #define TABLENUMBER     81
        #define PCSCALEVAL      100000000       //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  471 //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     256
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif
    #endif

    #ifdef HTPA32x32dL3_6HiSi_Rev1
        #define TABLENUMBER     106
        #define PCSCALEVAL      100000000       //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  471 //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     256
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif
    #endif
    
    #ifdef HTPA32x32dR1L3_6HiSi_Rev1_Gain3k3
        #define TABLENUMBER     117
        #define PCSCALEVAL      100000000       //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  1595    //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     1024
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif
        #define MBITTRIMDefault 0x2C
        #define SensRv 1
    #endif  

    #ifdef HTPA32x32dL7_0HiSi
        #define TABLENUMBER     107
        #define PCSCALEVAL      100000000       //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  471 //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     256
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif
    #endif
    
    #ifdef HTPA32x32dR1L7_0HiSi_Gain3k3
        #define TABLENUMBER     118
        #define PCSCALEVAL      100000000       //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  1595    //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     640
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif
        #define MBITTRIMDefault 0x2C
        #define SensRv 1
    #endif  

    #ifdef HTPA32x32dL2_1HiSiDLC
        #define TABLENUMBER     83
        #define PCSCALEVAL      100000000       //PixelConst scale value for table
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  471
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  64      //dig
        #define ADEXPBITS       6       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     512
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE 
            #undef FLOATTABLE
        #endif
    #endif

    #ifdef HTPA32x32dL2_1Si_withSiFilter
        #define TABLENUMBER     88
        #define PCSCALEVAL      100000000       //PixelConst scale value for table
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  471
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  8       //dig
        #define ADEXPBITS       3       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     64
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE 
            #undef FLOATTABLE
        #endif
    #endif

   #ifdef HTPA32x32dL5_0HiGeMult
        #define TABLENUMBER0        79
        #define PCSCALEVAL      100000000 //327000000000        //PixelConst scale value for table... lower 'L' for (long)
        #define NROFTAELEMENTS  7
        #define NROFADELEMENTS  251 //130 possible due to Program memory, higher values possible if NROFTAELEMENTS is decreased
        #define TAEQUIDISTANCE  100     //dK
        #define ADEQUIDISTANCE  128     //dig
        #define ADEXPBITS       7       //2^ADEXPBITS=ADEQUIDISTANCE
        #define TABLEOFFSET     256
        #define EQUIADTABLE     //if defined, ADELEMENTS have to be 2^N quantizied! else more CPU Power is needed
        #ifdef EQUIADTABLE
            #undef FLOATTABLE
        #endif   
    #endif
#endif
 
//
// I2C stuff
//
#define HTP_ADDRESS        (0x34)
#define HTP_EEPROM_ADDRESS (0xa0)

//
// REGISTERS: EEPROM
//
#define HTP_EEPROM_CALIB_HI       0x00
#define HTP_EEPROM_CALIB_LO       0x1A

#define HTP_EEPROM_PTAT_HI        0x00
#define HTP_EEPROM_PTAT_GRAD_LO   0x34
#define HTP_EEPROM_PTAT_OFFS_LO   0x38

#define HTP_EEPROM_TN_EPS_HI      0x00
#define HTP_EEPROM_TN_LO          0x0C
#define HTP_EEPROM_EPS_LO         0x0D

#define HTP_EEPROM_GRADSCALE_HI   0x00
#define HTP_EEPROM_GRADSCALE_LO   0x08

#define HTP_EEPROM_PIXC_HI        0x00
#define HTP_EEPROM_PIXCMIN_LO     0x00
#define HTP_EEPROM_PIXCMAX_LO     0x04

#define HTP_EEPROM_PIX_HI         0x17
#define HTP_EEPROM_PIX_LO         0x40

#define HTP_EEPROM_THGRAD_HI      0x07
#define HTP_EEPROM_THGRAD_LO      0x40

#define HTP_EEPROM_THOFFS_HI      0x0f
#define HTP_EEPROM_THOFFS_LO      0x40

//
// REGISTERS: HTP
//
#define HTP_CONFIG      0x01
#define HTP_STATUS      0x02
#define HTP_TRIM1_ADC   0x03
#define HTP_TRIM2_BIAS1 0x04
#define HTP_TRIM3_BIAS2 0x05
#define HTP_TRIM4_FREQ  0x06
#define HTP_TRIM5_BPA1  0x07
#define HTP_TRIM6_BPA2  0x08
#define HTP_TRIM7_PU    0x09
#define HTP_DATA1       0x0a
#define HTP_DATA2       0x0b


//
// CONFIG REGISTER CONFIGURATION BITS
//
#define CONFIG_WAKEUP     0B00000001
#define CONFIG_BLIND      0B00000010
#define CONFIG_START      0B00001000
#define CONFIG_BLOCK_LSB  0B00010000
#define CONFIG_BLOCK_MSB  0B00100000


//
// STATUS REGISTER CONFIGURATION BITS
//
#define STATUS_EOC        0B00000001
#define STATUS_BLOCK_LSB  0B00000100
#define STATUS_BLOCK_MSB  0B00001000

//
// TRIM1/ADC REGISTER CONFIGURATION BITS
//
#define TRIM1_ADC_MASK    0B00001111

//
// TRIM2/BIAS1 REGISTER CONFIGURATION BITS
// TRIM3/BIAS2 REGISTER CONFIGURATION BITS
//
#define TRIM_BIAS_MASK    0B00011111

//
// TRIM4/FREQ REGISTER CONFIGURATION BITS
//
#define TRIM_FREQ_MASK    0B00111111

//
// TRIM5/BPA1 REGISTER CONFIGURATION BITS
// TRIM6/BPA2 REGISTER CONFIGURATION BITS
//
#define TRIM_BPA_MASK    0B00011111

//
// TRIM7/PU REGISTER CONFIGURATION BITS
//
#define PU_SDA_1K         0B00010000
#define PU_SDA_10K        0B00100000
#define PU_SDA_50K        0B01000000
#define PU_SDA_100K       0b10000000
#define PU_SCL_1K         0B00000001
#define PU_SCL_10K        0B00000010
#define PU_SCL_50K        0B00000100
#define PU_SCL_100K       0B00001000

#define HTPA_PROC_RAW       0x00
#define HTPA_PROC_ELOFFS    0x01
#define HTPA_PROC_THOFFS    0x02
#define HTPA_PROC_CONVERT   0x04
//
// CLASS
//
class HTPA32x32
{
    public:        
        HTPA32x32(I2C * _i2c, I2C * _i2ce, uint8_t a1 = HTP_ADDRESS, uint8_t a2 = HTP_EEPROM_ADDRESS);
        volatile uint8_t
            mbit, bias, clk, bpa, pu, epsilon, gradScale, tn, proc, available;
        volatile int
            i2c_addr_htpa, i2c_addr_eeprom;
        volatile float
            PixC[1024], PixCmin, PixCmax, PTATgrad, PTAToffs;
        volatile uint16_t
            Ta_dK, Ta_dK_prev, Ta_dK_prev_prev;       
        volatile int16_t            
            Data[1024], ThGrad[1024], ThOffs[1024], ElOffs[256];
        volatile uint16_t
             TempTable_TA[NROFADELEMENTS];
        uint8_t
            ADC ( void ), ADC(uint8_t);
        uint8_t
            PU ( void ), PU(uint8_t);
        uint8_t
            BIAS ( void ), BIAS (uint8_t);
        uint8_t
            CLOCK ( void ), CLOCK (uint8_t);
        uint8_t 
            BPA ( void ), BPA (uint8_t);
        uint8_t
            end (void);
        void
            init( void );     
        void
            readb();
        void 
            start();
        void 
            apply_offsets( void );
        uint16_t 
            find_dk_from_v ( int16_t v );
            
    private:
        I2C * i2c, *i2ce;
        uint8_t 
            b;
        void 
            read_eeprom(uint8_t HiReg, uint8_t LoReg, char *data_ptr, int DCnt);            
        void 
            download_PIJ( void );
        void 
            find_temptable_from_ta ( void );
};



#endif
