#include "mbed.h"

/** Zumo Shield Control Class
*/
class ZumoShield {
    public:
    
        /** Create a Zumo shield object
         *
         * @param m1pwm Motor1 pwm pin
         * @param m1dir Motor1 direction pin
         * @param m2pwm Motor2 pwm pin
         * @param m2dir Motor2 direction pin
         */
        ZumoShield(PinName m1_pwm_pin, PinName m1_dir_pin,
                   PinName m2_pwm_pin, PinName m2_dir_pin);
                   //PinName a0_pin, PinName a1_pin, PinName a2_pin, PinName a3_pin, PinName a4_pin, PinName a5_pin);

        /** Switch on the left motor at the given speed.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motor.
         */
        void left_motor(float speed);
        
        /** Switch on the right motor at the given speed.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motor.
         */
        void right_motor(float speed);
        
        /** Switch on both motors, forwards at the given speed.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motor.
         */
        void forward(float speed);
        
        /** Switch on both motors, backwards at the given speed.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motor.
         */
        void backward(float speed);
        
        /** Switch on both motors at the given speed, in opposite directions so as to turn left.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motors.
        */
        void left(float speed);
        
        /** Switch on both motors at the given speed, in opposite directions so as to turn right.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motors.
         */
        void right(float speed);
        
        /** Turns left.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motor.
         */
        void turn_left(float speed);
        
        /** Turns right.
         *  @param speed The speed, from 0.0 to 1.0 at which to spin the motor.
         */
        void turn_right(float speed);
                
        /** Stop a chosen motor.
         *  @param motor Number, either 1 or 2 choosing the motor.
         */
        void stop(int motor);
        
        /** Stop left motor.
         */
        void stopLeft();
        
        /** Stop right motor.
         */
        void stopRight();
        
        /** Stop both motors at the same time. Different to disable.
         */
        void stopAll();
                        
        /** Gives an indication of the data given by the reflectivity sensors.
         */
        //float position();
        
    private:
        PwmOut m1pwm;
        PwmOut m2pwm;
        DigitalOut m1dir;        
        DigitalOut m2dir;
        /*
        AnalogIn a0sens;
        AnalogIn a1sens;
        AnalogIn a2sens;
        AnalogIn a3sens;
        AnalogIn a4sens;
        AnalogIn a5sens;
        */
};
