/**
 ******************************************************************************
 * @file    PLCOutput.h
 * @author  AST/CL
 * @version V1.0.0
 * @date    Feb 4th, 2016
 * @brief   This file contains the abstract class describing the interface of a
 *          PLC output component.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Define to prevent from recursive inclusion --------------------------------*/

#ifndef __PLCOUTPUT_CLASS_H
#define __PLCOUTPUT_CLASS_H


/* Includes ------------------------------------------------------------------*/

#include <Component.h>


/* Classes  ------------------------------------------------------------------*/

/** An abstract class for PLCOutut component.
 */
class PLCOutput : public Component
{
public:

    /**
     * @brief   Set output channels state
     * @param   Output channel data
     * @retval  None
     */
    virtual void set_channels(uint8_t Out_array) = 0;

    /**
     * @brief   Get output fault status
     * @param   None
     * @retval  Output channel fault data
     */
    virtual uint8_t manage_fault(void) = 0;

    /**
     * @brief   Get DC-DC status of the output channels component
     * @param   None
     * @retval  Feedback status, 1 if OK else 0
     */
     virtual uint8_t check_dcdc_status(void) = 0;

    /**
     * @brief   Get temperature warning status
     * @param   None
     * @retval  Temperature warning status, 1 if over temperature
     */
     virtual uint8_t temperature_warning(void) = 0;

    /**
     * @brief   Get parity check status
     * @param   None
     * @retval  Parity check flag
     */
     virtual uint8_t check_parity(void) = 0;

    /**
     * @brief   Get power supply status
     * @param   None
     * @retval  Power good bit, 1 in case of power good
     */
     virtual uint8_t check_power_good(void) = 0;

    /**
     * @brief   Get parity bits for input data
     * @param   None
     * @retval  Parity bits
     */
     virtual uint8_t check_comm_error(void) = 0;

    /**
     * @brief   Set output for output channels component
     * @param   TX buffer
     * @retval  None
     */
     virtual void ssrelay_set_output(uint8_t *outputArray) = 0;

    /**
     * @brief Destructor.
     */
    virtual ~PLCOutput() {};
};

#endif /* __PLCOUTPUT_CLASS_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/ 
