/**
  ******************************************************************************
  * @file    CLT01_38S_class.cpp
  * @author  System Lab Noida
  * @version V1.0.0
  * @date    08-July-2015
  * @brief   PLC_CLT01-38SQ7
  * This file provides firmware functions for how  to manage I/O from CLT01-38SQ7
  ==============================================================================    
 
           
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************  
  */
  
  /* Includes ------------------------------------------------------------------*/
#include "plc.h"

#include "CLT01_38S.h"
    
/** @addtogroup Drivers     Drivers
  * @{
  * @brief Demo Driver Layer
  */    
  
/** @addtogroup BSP     BSP
  * @{
  */    
    
/** @addtogroup Components     Components
  * @{
  */

/** @defgroup CLT01_38S    CLT01_38S
  * @{ 
  * @brief Digital Input Driver Layer
  */

/** @defgroup CLT01_38S_Private_variables     CLT01 38S Private variables
  * @{
  * @brief Digital Input Private variables
  */

/* Number of components */
uint8_t CLT01_38S::number_of_plc_input_components = 0;


/** @defgroup CLT01_38S_Exported_Functions     CLT01 38S Exported Functions
  * @{
  * @brief Digital Input exported Function 
  */

/**********************************************************
 * @brief Starts the CLT01_38S library
 * @param  init Initialization structure.
 * @retval COMPONENT_OK in case of success.
 **********************************************************/
status_t CLT01_38S::CLT01_38S_Init(void *init)
{
    OTA_Buffer = 0x00;
    CLT_PARITY_Buffer = 0x00;
    UVA_Buffer = 0x00;
    CLT_INPUT_STATUS_Buffer = 0x00;
    FLAG_CLT_READ = 0;
    
    /* Unselect the CLT chip at startup to avoid FAULT */
    ssel = 1;

    return COMPONENT_OK;
}

/**********************************************************
 * @brief Read id
 * @param id pointer to the identifier to be read.
 * @retval COMPONENT_OK in case of success.
 **********************************************************/
status_t CLT01_38S::CLT01_38S_ReadID(uint8_t *id)
{
  *id = plc_input_component_instance;

  return COMPONENT_OK;
}

/**********************************************************
 * @brief      CLT Read Status
 * @param      None
 * @retval     Status
 **********************************************************/
uint8_t CLT01_38S::CLT01_38S_GetReadStatus(void)
{
  return FLAG_CLT_READ;
}

/**********************************************************
 * @brief      Set CLT Read Status
 * @param      Status
 * @retval     None
 **********************************************************/
void CLT01_38S::CLT01_38S_SetReadStatus(uint8_t status)
{
  FLAG_CLT_READ = status;
}

/**********************************************************
 * @brief      INPUT status
 * @param      None
 * @retval     Channels status corresponding to 8 inputs 
 **********************************************************/
uint8_t CLT01_38S::CLT01_38S_GetInputData(void)
{
  CLT_INPUT_STATUS_Buffer = spi_rx_buff[1];
  
  return CLT_INPUT_STATUS_Buffer;
}

/**********************************************************
 * @brief      CLT Over_Temprature_Alarm
 * @param      None
 * @retval     Overtemperature bit, COMPONENT_ERROR in case of alarm
 **********************************************************/
status_t CLT01_38S::CLT01_38S_OverTempAlarm(void)
{
  OTA_Buffer = spi_rx_buff[0];
  OTA_Buffer = OTA_Buffer & (0x40);
 
  if(OTA_Buffer == 0x40) {
    return COMPONENT_OK;
  } else {
    return COMPONENT_ERROR;
  }
}

/**********************************************************
 * @brief      CLT Parity_Check_bits
 * @param      None
 * @retval     Parity bits for diagnosing inconsistency in data transmission 
 **********************************************************/
uint8_t CLT01_38S::CLT01_38S_CheckParity(void)
{
  CLT_PARITY_Buffer = spi_rx_buff[0];
  CLT_PARITY_Buffer = CLT_PARITY_Buffer & (0x3C);
  CLT_PARITY_Buffer = CLT_PARITY_Buffer >> 2;
  return CLT_PARITY_Buffer; 
}

/**********************************************************
 * @brief      CLT Under_Voltage_Alarm_bit
 * @param      None
 * @retval     Under voltage alarm bit, COMPONENT_ERROR in case of alarm
 **********************************************************/
status_t CLT01_38S::CLT01_38S_UnderVoltAlarm(void)
{
  UVA_Buffer = spi_rx_buff[0];
  UVA_Buffer = UVA_Buffer & (0x80);
  
  if(UVA_Buffer == 0x80) {
    return COMPONENT_OK;
  } else{ 
    return COMPONENT_ERROR; 
  }
}

/**********************************************************
 * @brief  Get input information from input channels component 
 * @param  rxBuff
 * @retval None
 **********************************************************/
void CLT01_38S::CLT01_38S_DigInpArray_GetInput(uint8_t *inputArray)
{
  if(CLT01_38S_SpiReadBytes(spi_tx_buff, spi_rx_buff) != 0) {
    /* Aborting the program */
    exit(EXIT_FAILURE);
  }
  inputArray[0] = spi_rx_buff[0];
  inputArray[1] = spi_rx_buff[1];
}

/**
  * @} //end CLT01_38S Exported Functions
  */

/**
  * @}  //end CLT01_38S Device Driver
  */
/**
  * @}  //end Components
   */
/**
  * @}  //close group  BSP
  */

/**
  * @}  //close group  Drivers
  */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/  
