/**
 ******************************************************************************
 * @file    PLCInput.h
 * @author  AST/CL
 * @version V1.0.0
 * @date    Feb 4th, 2016
 * @brief   This file contains the abstract class describing the interface of a
 *          PLC input component.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Define to prevent from recursive inclusion --------------------------------*/

#ifndef __PLCINPUT_CLASS_H
#define __PLCINPUT_CLASS_H


/* Includes ------------------------------------------------------------------*/

#include <Component.h>


/* Classes  ------------------------------------------------------------------*/

/** An abstract class for PLCInput component.
 */
class PLCInput : public Component
{
public:

    /**
     * @brief   Get Read Status
     * @param   None
     * @retval  Status
     */
    virtual uint8_t get_read_status(void) = 0;

    /**
     * @brief   Set Read Status
     * @param   Status
     * @retval  None
     */
    virtual void set_read_status(uint8_t status) = 0;

    /**
     * @brief   Get Input Status
     * @param   None
     * @retval  Channels status corresponding to 8 inputs
     */
     virtual uint8_t get_input_data(void) = 0;

    /**
     * @brief   Over Temperature Alarm bit
     * @param   None
     * @retval  Overtemperature bit, 1 in case of alarm
     */
     virtual uint8_t over_temp_alarm(void) = 0;

    /**
     * @brief   Parity Check bits
     * @param   None
     * @retval  Parity bits for diagnosing inconsistency in data transmission
     */
     virtual uint8_t check_parity(void) = 0;

    /**
     * @brief   Under Voltage Alarm bit
     * @param   None
     * @retval  Under voltage alarm bit, 1 in case of alarm
     */
     virtual uint8_t under_volt_alarm(void) = 0;

    /**
     * @brief   Get input information from input channels component
     * @param   RX buffer
     * @retval  None
     */
     virtual void dig_inp_array_get_input(uint8_t *inputArray) = 0;
     
     /**
      * @brief  Auxiliary method to enable or disable SPI CS pin.
      * @param  l flag to enable or disable SPI CS pin
      */
     virtual void set_input_spi(uint8_t l) = 0;

    /**
     * @brief Destructor.
     */
    virtual ~PLCInput() {};
};

#endif /* __PLCINPUT_CLASS_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/ 
