/**
 ******************************************************************************
 * @file    plc.h
 * @author  System Lab Noida
 * @version V1.0.0
 * @date    08-July-2015
 * @brief   This header file contains the functions prototypes for the
 *          plc driver.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef __PLC_H
#define __PLC_H

#ifdef __cplusplus
extern "C" {
#endif


/* Includes ------------------------------------------------------------------*/

#include <stdint.h>
#include "component_def.h"


/* Definitions ---------------------------------------------------------------*/

/** @addtogroup BSP
  * @{
  */

/** @addtogroup Components
  * @{
  */

/** @addtogroup PLC
  * @{
  */

/** @defgroup PLC_Exported_Constants
  * @{
  */
#define MAX_NUMBER_OF_PLC_INPUT_COMPONENTS 1
#define MAX_NUMBER_OF_PLC_OUTPUT_COMPONENTS 1

#define NB_BYTES 2
#define BUFFERSIZE 1


/* Types ---------------------------------------------------------------------*/

/** @defgroup PLC_Exported_Types
  * @{
  */

/** @defgroup PLC_Exported_variables     plc Exported variables
  * @{
  * @brief Exported variables 
  */

/**
 * @brief  SSRELAY driver structure definition
 */
typedef struct
{
  void (*SetChannels) (uint8_t Out_array);
  uint8_t (*ManageFault)(void);
  uint8_t (*CheckDCDCStatus)(void);
  uint8_t (*TemperatureWarning)(void);
  uint8_t (*CheckParity)(void);
  uint8_t (*CheckPowerGood)(void);
  uint8_t (*CheckCommError)(void);
  void (*Ssrelay_SetOutput)(uint8_t *TxBuff, uint8_t *RxBuff);
} SSRELAY_DrvTypeDef;


/**
 * @brief  DIGITALINPUTARRAY driver structure definition
 */
typedef struct
{
  uint8_t (*GetReadStatus)(void);
  void (*SetReadStatus)(uint8_t status);
  uint8_t (*GetInputData)(void);
  uint8_t (*OverTempAlarm)(void);
  uint8_t (*CheckParity)(void);
  uint8_t (*UnderVoltAlarm)(void);
  void (*DigInpArray_GetInput)(uint8_t *TxBuff, uint8_t *RxBuff);       
} DIGITALINPUTARRAY_DrvTypeDef;
    

/* Functions -----------------------------------------------------------------*/

/**
 * @brief      Converts two uint8_t words into one of uint16_t
 * @param[in]  ptr pointer to the buffer of data to be converted.
 * @retval     16-bit data.
 */
inline uint16_t convertFrom8To16(uint8_t *ptr)
{
    uint16_t data16 = 0x0000;
    
    data16 = *ptr;
    data16 |= *(++ptr) << 8;
    
    return data16;
}

/**
 * @brief      Converts one uint16_t word into two uint8_t
 * @param[in]  ptr pointer to the buffer of uint8_t words.
 * @param[in]  16-bit data.
 * @retval     none.
 */
inline void convertFrom16To8(uint16_t data16, uint8_t *ptr)
{
    *(ptr) = data16 & 0x00FF;
    *(++ptr) = (data16 >> 8) & 0x00FF;
}

/**
 * @}
 */

/**
 * @}
 */

/**
 * @}
 */

/**
 * @}
 */

#ifdef   __cplusplus
}
#endif

#endif /* __PLC_H */
/**
  * @} // end   plc Exported Function
  */
/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
