/**
 ******************************************************************************
 * @file    XNucleoOUT01A1.h
 * @author  ST CLab
 * @version V1.0.0
 * @date    1 February 2018
 * @brief   Abstract class of X-NUCLEO-OUT01A1 board
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Prevent recursive inclusion -----------------------------------------------*/

#ifndef __XNUCLEOOUT01A1_H__
#define __XNUCLEOOUT01A1_H__


/* Includes ------------------------------------------------------------------*/

#include "ISO8200BQ.h"

/* Class Declaration ---------------------------------------------------------*/

/* Types ---------------------------------------------------------------------*/

typedef enum
{
    mode_sync, 
    mode_direct
} control_mode_t;

/**
 * Abstract class of X-NUCLEO_OUT01A1 Expansion Board. 
 * Default reflecting STM32 Nucleos pinout. 
 */
 
class XNucleoOUT01A1
{
public:

    XNucleoOUT01A1(control_mode_t ctl_mode=mode_direct, 
            PinName CTL_MODE_PIN=NC, PinName OUT_EN=A3, PinName N_SYNC=A4, 
            PinName N_LOAD=A5, PinName IN1=A0, PinName IN2=A1, PinName IN3=NC, 
            PinName IN4=A2, PinName IN5=D5, PinName IN6=D4, PinName IN7=D14, 
            PinName IN8=D15);

    void set_inputs(uint8_t input_values);
    
    void update_outputs(void);
    
    void enable_outputs(bool enable);

private:
    ISO8200BQ iso8200bq;
    control_mode_t _mode; 
    DigitalIn *_ctl_mode_pin;
    DigitalOut *_in_array[8];
};
    

#endif