/**
 ******************************************************************************
 * @file    ISO8200BQ.h
 * @author  ST CLab
 * @version V1.0.0
 * @date    1 February 2018
 * @brief   Abstract class of a ISO8200BQ octal smart power solid state-relay
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Prevent recursive inclusion -----------------------------------------------*/

#ifndef __ISO8200BQ_H__
#define __ISO8200BQ_H__


/* Includes ------------------------------------------------------------------*/

#include <mbed.h>
#include <assert.h>
#include "Component.h"
 

/* Class Declaration ---------------------------------------------------------*/

/**
 * Abstract class of a ISO8200BQ octal smart power solid state-relay.
 */
class ISO8200BQ : public Component
{
  public:
    ISO8200BQ (PinName OUT_EN, PinName N_SYNC, 
        PinName N_LOAD);
    virtual int init(void *init);
    virtual int read_id(uint8_t *id);
    void enable_outputs(bool enable);
    bool are_outputs_enabled (void);
    void sync_mode_load_inputs (void);
    void sync_mode_update_outputs(void);
    void direct_mode (void);
  
  private:
    DigitalOut _out_en;
    DigitalOut _n_sync;
    DigitalOut _n_load;
};

#endif