/**
  ******************************************************************************
  * @file       X_NUCLEO_NFC01A1.h
  * @date       05/11/2015
  * @brief      singleton class that controls all the electronics inside the 
  * 			X_NUCLEO_NFC01A1 expansion board
  ******************************************************************************
  *
  * COPYRIGHT(c) 2015 STMicroelectronics
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

#ifndef X_NUCLEO_NFC01A1_H_
#define X_NUCLEO_NFC01A1_H_
#include <stdint.h>

#include "mbed.h"

#include "m24sr/m24sr_class.h"

/**
 * singleton class that controls all the electronics inside the X_NUCLEO_NFC01A1 expansion board
 */
class X_NUCLEO_NFC01A1 {

private:
	/**
	 * ponter to the singleton instance, NULL if we did't build one
	 */
	static X_NUCLEO_NFC01A1 *mInstance;
	/**
	 * i2c address of the m24sr chip
	 */
	static const uint8_t M24SR_ADDR;

	static const PinName GPO_PIN;
	static const PinName RF_DISABLE_PIN;
	static const PinName LED1_PIN;
	static const PinName LED2_PIN;
	static const PinName LED3_PIN;

	/**
	 * constructor
	 * @param devI2C i2c channel used for communicate with the board
	 * @param gpoName pin of the gpio pin of the M24SR chip
	 * @param RFDisableName pin for disable the rf antenna
	 * @param led1Name pin for control the led1 status
	 * @param led2Name pin for control the led1 status
	 * @param led3Name pin for control the led1 status
	 */
	X_NUCLEO_NFC01A1(I2C &devI2C) :
			mM24SR(M24SR_ADDR, devI2C, GPO_PIN, RF_DISABLE_PIN), mNfcLed1(
					LED1_PIN), mNfcLed2(LED2_PIN), mNfcLed3(LED3_PIN) {	}

public:
	const static PinName DEFAULT_SDA_PIN;
	const static PinName DEFAULT_SDL_PIN;

	static X_NUCLEO_NFC01A1* Instance(I2C &devI2C);

	/**
	 * @return board led1
	 */
	DigitalOut& getLed1() {
		return mNfcLed1;
	}

	/**
	 * @return board led2
	 */
	DigitalOut& getLed2() {
		return mNfcLed2;
	}

	/**
	 * @return board led3
	 */
	DigitalOut& getLed3() {
		return mNfcLed3;
	}

	/**
	 * @return NFC Chip
	 */
	M24SR& getM24SR() {
		return mM24SR;
	}

	virtual ~X_NUCLEO_NFC01A1() {
	}

private:

	M24SR mM24SR;
	DigitalOut mNfcLed1;
	DigitalOut mNfcLed2;
	DigitalOut mNfcLed3;

};

#endif /* X_NUCLEO_NFC01A1_H_ */
