/**
 ******************************************************************************
 * @file    TSV734.c
 * @author  Central Labs
 * @version 1.0.0
 * @date    11-February-2016
 * @brief   Portable architecture for TSV734
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Generated with STM32CubeTOO -----------------------------------------------*/


/* Revision ------------------------------------------------------------------*/
/*
	Repository:       http://svn.x-nucleodev.codex.cro.st.com/svnroot/X-NucleoDev
	Branch/Trunk/Tag: trunk
	Based on:         X-CUBE-IKA01A1/trunk/Drivers/BSP/Components/tsv734/tsv734.h
	Revision:         402
*/


/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef __TSV734_CLASS_H
#define __TSV734_CLASS_H


/* Includes ------------------------------------------------------------------*/

/* ACTION 1 ------------------------------------------------------------------*
 * Include here platform specific header files.                               *
 *----------------------------------------------------------------------------*/		
#include "mbed.h"
/* ACTION 2 ------------------------------------------------------------------*
 * Include here component specific header files.                              *
 *----------------------------------------------------------------------------*/		
#include "tsv734.h"
/* ACTION 3 ------------------------------------------------------------------*
 * Include here interface specific header files.                              *
 *                                                                            *
 * Example:                                                                   *
 *   #include "../Interfaces/Humidity_class.h"                                *
 *   #include "../Interfaces/Temperature_class.h"                             *
 *----------------------------------------------------------------------------*/
#include "../Interfaces/Led_driver_class.h"


/* Classes -------------------------------------------------------------------*/

/**
 * @brief Class representing a TSV734 component.
 */
class TSV734 : public Led_driver
{
public:

	/*** Constructor and Destructor Methods ***/

	/**
	 * @brief Constructor.
	 */
	TSV734(void) : Led_driver()
	{
		/* ACTION 4 ----------------------------------------------------------*
		 * Initialize here the component's member variables, one variable per *
		 * line.                                                              *
		 *                                                                    *
		 * Example:                                                           *
		 *   measure = 0;                                                     *
		 *   instance_id = number_of_instances++;                             *
		 *--------------------------------------------------------------------*/
	}
	
	/**
	 * @brief Destructor.
	 */
	virtual ~TSV734(void) {}
	

	/*** Public Component Related Methods ***/

	/* ACTION 5 --------------------------------------------------------------*
	 * Implement here the component's public methods, as wrappers of the C    *
	 * component's functions.                                                 *
	 * They should be:                                                        *
	 *   + Methods with the same name of the C component's virtual table's    *
	 *     functions (1);                                                     *
	 *   + Methods with the same name of the C component's extended virtual   *
	 *     table's functions, if any (2).                                     *
	 *                                                                        *
	 * Example:                                                               *
	 *   virtual int GetValue(float *f)  //(1)                                *
	 *   {                                                                    *
	 *     return COMPONENT_GetValue(float *f);                               *
	 *   }                                                                    *
	 *                                                                        *
	 *   virtual int EnableFeature(void) //(2)                                *
	 *   {                                                                    *
	 *     return COMPONENT_EnableFeature();                                  *
	 *   }                                                                    *
	 *------------------------------------------------------------------------*/
	virtual int Init(void *init = NULL)
	{
		return (int) TSV734_Init((void *) init);
	}

	virtual int ReadID(uint8_t *id = NULL)
	{
		return (int) TSV734_ReadID((uint8_t *) id);
	}
	
	virtual int Configure(PinName pinName, unsigned int period_us)
	{
		pwmPinName = pinName;
		PwmOut ledOut(pwmPinName);
		period = period_us;
		ledOut.period_ms(period);
		return 0;
	}	

	virtual int SetDutyCycle(float dc)
	{
		PwmOut ledOut(pwmPinName);
		ledOut.pulsewidth_us((period*dc)/100);
		return (int) dc;
	}


	/*** Public Interrupt Related Methods ***/

	/* ACTION 6 --------------------------------------------------------------*
	 * Implement here interrupt related methods, if any.                      *
	 * Note that interrupt handling is platform dependent, e.g.:              *
	 *   + mbed:                                                              *
	 *     InterruptIn feature_irq(pin);           //Interrupt object.        *
	 *     feature_irq.fall(callback);             //Attach a callback.       *
	 *     feature_irq.mode(PullNone);             //Set interrupt mode.      *
	 *     feature_irq.enable_irq();               //Enable interrupt.        *
	 *     feature_irq.disable_irq();              //Disable interrupt.       *
	 *   + Arduino:                                                           *
	 *     attachInterrupt(pin, callback, RISING); //Attach a callback.       *
	 *     detachInterrupt(pin);                   //Detach a callback.       *
	 *                                                                        *
	 * Example (mbed):                                                        *
	 *   void AttachFeatureIRQ(void (*fptr) (void))                           *
	 *   {                                                                    *
	 *     feature_irq.fall(fptr);                                            *
	 *   }                                                                    *
	 *                                                                        *
	 *   void EnableFeatureIRQ(void)                                          *
	 *   {                                                                    *
	 *     feature_irq.enable_irq();                                          *
	 *   }                                                                    *
	 *                                                                        *
	 *   void DisableFeatureIRQ(void)                                         *
	 *   {                                                                    *
	 *     feature_irq.disable_irq();                                         *
	 *   }                                                                    *
	 *------------------------------------------------------------------------*/


protected:

	/*** Protected Component Related Methods ***/

	/* ACTION 7 --------------------------------------------------------------*
	 * Declare here the component's specific methods.                         *
	 * They should be:                                                        *
	 *   + Methods with the same name of the C component's virtual table's    *
	 *     functions (1);                                                     *
	 *   + Methods with the same name of the C component's extended virtual   *
	 *     table's functions, if any (2);                                     *
	 *   + Helper methods, if any, like functions declared in the component's *
	 *     source files but not pointed by the component's virtual table (3). *
	 *                                                                        *
	 * Example:                                                               *
	 *   Status_t COMPONENT_GetValue(float *f);   //(1)                       *
	 *   Status_t COMPONENT_EnableFeature(void);  //(2)                       *
	 *   Status_t COMPONENT_ComputeAverage(void); //(3)                       *
	 *------------------------------------------------------------------------*/
	/* TSV734's generic functions. */
	Status_t TSV734_Init(void *init);
	Status_t TSV734_ReadID(void *id);

	/* TSV734's interrupts related functions. */
	Status_t TSV734_ConfigIT(void* a);
	Status_t TSV734_SetDutyCycle(float dutyCycle);
	unsigned int period;
	PinName pwmPinName;


	/*** Component's I/O Methods ***/

	/* ACTION 8 --------------------------------------------------------------*
	 * Implement here other I/O methods beyond those already implemented      *
	 * above, which are declared extern within the component's header file.   *
	 *------------------------------------------------------------------------*/
	Status_t TSV734_Write_Pin_D3(unsigned int dc)
	{
		/* TO BE IMPLEMENTED BY USING TARGET PLATFORM'S APIs. */
		return (Status_t) 0;
	}


	/*** Component's Instance Variables ***/

	/* ACTION 9 --------------------------------------------------------------*
	 * Declare here interrupt related variables, if needed.                   *
	 * Note that interrupt handling is platform dependent, see                *
	 * "Interrupt Related Methods" above.                                     *
	 *                                                                        *
	 * Example:                                                               *
	 *   + mbed:                                                              *
	 *     InterruptIn feature_irq;                                           *
	 *------------------------------------------------------------------------*/

	/* ACTION 10 -------------------------------------------------------------*
	 * Declare here other pin related variables, if needed.                   *
	 *                                                                        *
	 * Example:                                                               *
	 *   + mbed:                                                              *
	 *     DigitalOut standby_reset;                                          *
	 *------------------------------------------------------------------------*/

	/* ACTION 11 -------------------------------------------------------------*
	 * Declare here communication related variables, if needed.               *
	 *                                                                        *
	 * Example:                                                               *
	 *   + mbed:                                                              *
	 *     DigitalOut address;                                                *
	 *     DevI2C &dev_i2c;                                                   *
	 *------------------------------------------------------------------------*/

	/* ACTION 12 -------------------------------------------------------------*
	 * Declare here identity related variables, if needed.                   *
	 * Note that there should be only a unique identifier for each component, *
	 * which should be the "who_am_i" parameter.                              *
	 *------------------------------------------------------------------------*/
	/* Identity */
	uint8_t who_am_i;


	/* ACTION 13 -------------------------------------------------------------*
	 * Declare here the component's static and non-static data, one variable  *
	 * per line.                                                              *
	 *                                                                        *
	 * Example:                                                               *
	 *   float measure;                                                       *
	 *   int instance_id;                                                     *
	 *   static int number_of_instances;                                      *
	 *------------------------------------------------------------------------*/
};

#endif /* __TSV734_CLASS_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/