/**
 ******************************************************************************
 * @file    x_nucleo_ika01a1_class.cpp
 * @author  AST / Software Platforms and Cloud
 * @version V1.0
 * @date    October 1st, 2015
 * @brief   Implementation file for the X_NUCLEO_IKA01A1 expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Generated with STM32CubeTOO -----------------------------------------------*/


/* Includes ------------------------------------------------------------------*/

/* ACTION 1 ------------------------------------------------------------------*
 * Include here platform specific header files.                               *
 *----------------------------------------------------------------------------*/
#include "mbed.h"
/* ACTION 2 ------------------------------------------------------------------*
 * Include here expansion board specific header files.                        *
 *----------------------------------------------------------------------------*/
#include "x_nucleo_ika01a1_class.h"


/* Variables -----------------------------------------------------------------*/

/* Singleton instance of X_NUCLEO_IKA01A1 class. */
X_NUCLEO_IKA01A1 *X_NUCLEO_IKA01A1::_instance;


/* Methods -------------------------------------------------------------------*/

/**
 * @brief Constructor.
 */
X_NUCLEO_IKA01A1::X_NUCLEO_IKA01A1(void)
{
	/* Instantiating the components. */
	/* ACTION 3 --------------------------------------------------------------*
	 * Instantiate here the expansion board's components.                     *
	 *                                                                   	  *
	 * Example:                                                          	  *
	 *   component_1 = new COMPONENT_1();                                     *
	 *   component_2 = new COMPONENT_2();                                     *
	 *------------------------------------------------------------------------*/
	tsz124 = new TSZ124();
	tsu104 = new TSU104();
	tsv734 = new TSV734();
}

/**
 * @brief Getting a singleton instance of X_NUCLEO_IKA01A1 class.
 * @retval a singleton instance of X_NUCLEO_IKA01A1 class.
 */
X_NUCLEO_IKA01A1 *X_NUCLEO_IKA01A1::Instance(void)
{
	if (_instance == NULL)
	{
		/* Instantiating the board. */
		_instance = new X_NUCLEO_IKA01A1();

		/* Initializing the components. */
		if (!_instance->Init())
			error("Initialization of the X_NUCLEO_IKA01A1 expansion board failed.\n");
	}

	return _instance;
}

/**
 * @brief Initializing the X_NUCLEO_IKA01A1 board.
 * @retval true if initialization is successful, false otherwise.
 */
bool X_NUCLEO_IKA01A1::Init(void)
{
	/* Initializing the components. */
	/* ACTION 4 --------------------------------------------------------------*
	 * Initialize here the expansion board's components.                 	  *
	 *                                                                   	  *
	 * Example:                                                          	  *
	 *   return (Init_COMPONENT_1() && Init_COMPONENT_2());              	  *
	 *------------------------------------------------------------------------*/
	//return (Init_TSZ124() && Init_TSU104() && Init_TSV734());
	return true;
}

/* ACTION 5 ------------------------------------------------------------------*
 * Implement here an initialization method for each expansion board's         *
 * component.                                                                 *
 *                                                                            *
 * Example:                                                                   *
 *   bool EXPANSION_BOARD::Init_COMPONENT_1(void)                             *
 *   {                                                                        *
 *     // Verifying identity.                                                 *
 *     uint8_t id = 0;                                                        *
 *     int ret = component_1->ReadID(&id);                                    *
 *     if ((ret != COMPONENT_OK) || (id != I_AM_COMPONENT_1))                 *
 *     {                                                                      *
 *       delete component_1;                                                  *
 *       component_1 = NULL;                                                  *
 *       return true;                                                         *
 *     }                                                                      *
 *                                                                            *
 *     // Configuration.                                                      *
 *     COMPONENT_Init_t InitStructure;                                        *
 *     InitStructure.Property_1 = COMPONENT_1_PROPERY_1_INIT;                 *
 *     InitStructure.Property_N = COMPONENT_1_PROPERY_N_INIT;                 *
 *                                                                            *
 *     // Initialization.                                                     *
 *     if (component_1->Init(&InitStructure) != COMPONENT_OK)                 *
 *       return false;                                                        *
 *                                                                            *
 *     return true;                                                           *
 *   }                                                                        *
 *----------------------------------------------------------------------------*/
/**
 * @brief  Initialize the TSZ124 component.
 * @retval true if initialization is successful, false otherwise.
 */
bool X_NUCLEO_IKA01A1::Init_TSZ124(void)
{
	/* Verifying identity. */
	uint8_t id = 0;
	int ret = tsz124->ReadID(&id);
	if ((ret != COMPONENT_OK) || (id != I_AM_TSZ124))
	{
		delete tsz124;
		tsz124 = NULL;
		return true;
	}

	/* Configuration. */
	void* InitStructure = NULL;
	/* ACTION ----------------------------------------------------------------*
	 * Configure here the component's initialization structure.               *
	 *                                                                        *
	 * Example:                                                          	  *
	 *   InitStructure.Property_1 = COMPONENT_PROPERY_1_INIT;                 *
	 *   InitStructure.Property_N = COMPONENT_PROPERY_N_INIT;                 *
	 *------------------------------------------------------------------------*/

	/* Initialization. */
	if (tsz124->Init(&InitStructure) != COMPONENT_OK)
		return false;

	return true;
}

/**
 * @brief  Initialize the TSU104 component.
 * @retval true if initialization is successful, false otherwise.
 */
bool X_NUCLEO_IKA01A1::Init_TSU104(void)
{
	/* Verifying identity. */
	uint8_t id = 0;
	int ret = tsu104->ReadID(&id);
	if ((ret != COMPONENT_OK) || (id != I_AM_TSU104))
	{
		delete tsu104;
		tsu104 = NULL;
		return true;
	}

	/* Configuration. */
	void* InitStructure = NULL;
	/* ACTION ----------------------------------------------------------------*
	 * Configure here the component's initialization structure.               *
	 *                                                                        *
	 * Example:                                                          	  *
	 *   InitStructure.Property_1 = COMPONENT_PROPERY_1_INIT;                 *
	 *   InitStructure.Property_N = COMPONENT_PROPERY_N_INIT;                 *
	 *------------------------------------------------------------------------*/

	/* Initialization. */
	if (tsu104->Init(&InitStructure) != COMPONENT_OK)
		return false;

	return true;
}

/**
 * @brief  Initialize the TSV734 component.
 * @retval true if initialization is successful, false otherwise.
 */
bool X_NUCLEO_IKA01A1::Init_TSV734(void)
{
	/* Verifying identity. */
	uint8_t id = 0;
	int ret = tsv734->ReadID(&id);
	if ((ret != COMPONENT_OK) || (id != I_AM_TSV734))
	{
		delete tsv734;
		tsv734 = NULL;
		return true;
	}

	/* Configuration. */
	void* InitStructure = NULL;
	/* ACTION ----------------------------------------------------------------*
	 * Configure here the component's initialization structure.               *
	 *                                                                        *
	 * Example:                                                          	  *
	 *   InitStructure.Property_1 = COMPONENT_PROPERY_1_INIT;                 *
	 *   InitStructure.Property_N = COMPONENT_PROPERY_N_INIT;                 *
	 *------------------------------------------------------------------------*/

	/* Initialization. */
	if (tsv734->Init(&InitStructure) != COMPONENT_OK)
		return false;

	return true;
}

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/