/**
 ******************************************************************************
 * @file    TSZ124.c
 * @author  Central Labs
 * @version 1.0.0
 * @date    11-February-2016
 * @brief   Portable architecture for TSZ124
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Generated with STM32CubeTOO -----------------------------------------------*/


/* Revision ------------------------------------------------------------------*/
/*
	Repository:       http://svn.x-nucleodev.codex.cro.st.com/svnroot/X-NucleoDev
	Branch/Trunk/Tag: trunk
	Based on:         X-CUBE-IKA01A1/trunk/Drivers/BSP/Components/tsz124/tsz124.h
	Revision:         402
*/


/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef __TSZ124_CLASS_H
#define __TSZ124_CLASS_H


/* Includes ------------------------------------------------------------------*/

/* ACTION 1 ------------------------------------------------------------------*
 * Include here platform specific header files.                               *
 *----------------------------------------------------------------------------*/		
#include "mbed.h"
/* ACTION 2 ------------------------------------------------------------------*
 * Include here component specific header files.                              *
 *----------------------------------------------------------------------------*/		
#include "tsz124.h"
/* ACTION 3 ------------------------------------------------------------------*
 * Include here interface specific header files.                              *
 *                                                                            *
 * Example:                                                                   *
 *   #include "../Interfaces/Humidity_class.h"                                *
 *   #include "../Interfaces/Temperature_class.h"                             *
 *----------------------------------------------------------------------------*/
#include "../Interfaces/Instrumentation_amp_class.h"


/* Classes -------------------------------------------------------------------*/

/**
 * @brief Class representing a TSZ124 component.
 */
class TSZ124 : public Instrumentation_amp
{
public:

	/*** Constructor and Destructor Methods ***/

	/**
	 * @brief Constructor.
	 */
	TSZ124(void) : Instrumentation_amp()
	{
		/* ACTION 4 ----------------------------------------------------------*
		 * Initialize here the component's member variables, one variable per *
		 * line.                                                              *
		 *                                                                    *
		 * Example:                                                           *
		 *   measure = 0;                                                     *
		 *   instance_id = number_of_instances++;                             *
		 *--------------------------------------------------------------------*/
	}
	
	/**
	 * @brief Destructor.
	 */
	virtual ~TSZ124(void) {}
	

	/*** Public Component Related Methods ***/

	/* ACTION 5 --------------------------------------------------------------*
	 * Implement here the component's public methods, as wrappers of the C    *
	 * component's functions.                                                 *
	 * They should be:                                                        *
	 *   + Methods with the same name of the C component's virtual table's    *
	 *     functions (1);                                                     *
	 *   + Methods with the same name of the C component's extended virtual   *
	 *     table's functions, if any (2).                                     *
	 *                                                                        *
	 * Example:                                                               *
	 *   virtual int GetValue(float *f)  //(1)                                *
	 *   {                                                                    *
	 *     return COMPONENT_GetValue(float *f);                               *
	 *   }                                                                    *
	 *                                                                        *
	 *   virtual int EnableFeature(void) //(2)                                *
	 *   {                                                                    *
	 *     return COMPONENT_EnableFeature();                                  *
	 *   }                                                                    *
	 *------------------------------------------------------------------------*/
	virtual int Init(void *init = NULL)
	{
		return (int) TSZ124_Init((void *) init);
	}

	virtual int ReadID(uint8_t *id = NULL)
	{
		return (int) TSZ124_ReadID((uint8_t *) id);
	}

	virtual unsigned int GetVoltage(void)
	{
		const unsigned int ADC_RANGE_12_BIT = 0xFFF;
		AnalogIn   ain(A1);
		return ain.read()*805.0*ADC_RANGE_12_BIT/1000.0;
	}

	virtual unsigned int GetCurrent(void)
	{
		const unsigned int ADC_RANGE_12_BIT = 0xFFF;
		AnalogIn   ain(A2);
		return ain.read()*1000.0*805.0*ADC_RANGE_12_BIT/1000.0/1586.0;
	}


	/*** Public Interrupt Related Methods ***/

	/* ACTION 6 --------------------------------------------------------------*
	 * Implement here interrupt related methods, if any.                      *
	 * Note that interrupt handling is platform dependent, e.g.:              *
	 *   + mbed:                                                              *
	 *     InterruptIn feature_irq(pin);           //Interrupt object.        *
	 *     feature_irq.fall(callback);             //Attach a callback.       *
	 *     feature_irq.mode(PullNone);             //Set interrupt mode.      *
	 *     feature_irq.enable_irq();               //Enable interrupt.        *
	 *     feature_irq.disable_irq();              //Disable interrupt.       *
	 *   + Arduino:                                                           *
	 *     attachInterrupt(pin, callback, RISING); //Attach a callback.       *
	 *     detachInterrupt(pin);                   //Detach a callback.       *
	 *                                                                        *
	 * Example (mbed):                                                        *
	 *   void AttachFeatureIRQ(void (*fptr) (void))                           *
	 *   {                                                                    *
	 *     feature_irq.fall(fptr);                                            *
	 *   }                                                                    *
	 *                                                                        *
	 *   void EnableFeatureIRQ(void)                                          *
	 *   {                                                                    *
	 *     feature_irq.enable_irq();                                          *
	 *   }                                                                    *
	 *                                                                        *
	 *   void DisableFeatureIRQ(void)                                         *
	 *   {                                                                    *
	 *     feature_irq.disable_irq();                                         *
	 *   }                                                                    *
	 *------------------------------------------------------------------------*/


protected:

	/*** Protected Component Related Methods ***/

	/* ACTION 7 --------------------------------------------------------------*
	 * Declare here the component's specific methods.                         *
	 * They should be:                                                        *
	 *   + Methods with the same name of the C component's virtual table's    *
	 *     functions (1);                                                     *
	 *   + Methods with the same name of the C component's extended virtual   *
	 *     table's functions, if any (2);                                     *
	 *   + Helper methods, if any, like functions declared in the component's *
	 *     source files but not pointed by the component's virtual table (3). *
	 *                                                                        *
	 * Example:                                                               *
	 *   Status_t COMPONENT_GetValue(float *f);   //(1)                       *
	 *   Status_t COMPONENT_EnableFeature(void);  //(2)                       *
	 *   Status_t COMPONENT_ComputeAverage(void); //(3)                       *
	 *------------------------------------------------------------------------*/
	/* TSZ124's generic functions. */
	Status_t TSZ124_Init(void *init);
	Status_t TSZ124_ReadID(void *id);

	/* TSZ124's interrupts related functions. */
	Status_t TSZ124_ConfigIT(void* a);


	/*** Component's I/O Methods ***/

	/* ACTION 8 --------------------------------------------------------------*
	 * Implement here other I/O methods beyond those already implemented      *
	 * above, which are declared extern within the component's header file.   *
	 *------------------------------------------------------------------------*/
	unsigned int TSZ124_Read_Pin_A1()
	{
		/* TO BE IMPLEMENTED BY USING TARGET PLATFORM'S APIs. */
		return (Status_t) 0;
	}

	unsigned int TSZ124_Read_Pin_A2()
	{
		/* TO BE IMPLEMENTED BY USING TARGET PLATFORM'S APIs. */
		return (Status_t) 0;
	}


	/*** Component's Instance Variables ***/

	/* ACTION 9 --------------------------------------------------------------*
	 * Declare here interrupt related variables, if needed.                   *
	 * Note that interrupt handling is platform dependent, see                *
	 * "Interrupt Related Methods" above.                                     *
	 *                                                                        *
	 * Example:                                                               *
	 *   + mbed:                                                              *
	 *     InterruptIn feature_irq;                                           *
	 *------------------------------------------------------------------------*/

	/* ACTION 10 -------------------------------------------------------------*
	 * Declare here other pin related variables, if needed.                   *
	 *                                                                        *
	 * Example:                                                               *
	 *   + mbed:                                                              *
	 *     DigitalOut standby_reset;                                          *
	 *------------------------------------------------------------------------*/

	/* ACTION 11 -------------------------------------------------------------*
	 * Declare here communication related variables, if needed.               *
	 *                                                                        *
	 * Example:                                                               *
	 *   + mbed:                                                              *
	 *     DigitalOut address;                                                *
	 *     DevI2C &dev_i2c;                                                   *
	 *------------------------------------------------------------------------*/

	/* ACTION 12 -------------------------------------------------------------*
	 * Declare here identity related variables, if needed.                    *
	 * Note that there should be only a unique identifier for each component, *
	 * which should be the "who_am_i" parameter.                              *
	 *------------------------------------------------------------------------*/
	/* Identity */
	uint8_t who_am_i;

	/* ACTION 13 -------------------------------------------------------------*
	 * Declare here the component's static and non-static data, one variable  *
	 * per line.                                                              *
	 *                                                                        *
	 * Example:                                                               *
	 *   float measure;                                                       *
	 *   int instance_id;                                                     *
	 *   static int number_of_instances;                                      *
	 *------------------------------------------------------------------------*/
};

#endif /* __TSZ124_CLASS_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/