/**
 ******************************************************************************
 * @file    Motor_class.h
 * @author  AST
 * @version V1.0.0
 * @date    April 13th, 2015
 * @brief   This file contains the abstract class describing the interface of a
 *          motor component.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Generated with STM32CubeTOO -----------------------------------------------*/


/* Revision ------------------------------------------------------------------*/
/*
	Repository:       http://svn.x-nucleodev.codex.cro.st.com/svnroot/X-NucleoDev
	Branch/Trunk/Tag: trunk
	Based on:         X-CUBE-SPN4/trunk/Drivers/BSP/Components/Common/motor.h
	Revision:         0
*/


/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef __MOTOR_CLASS_H
#define __MOTOR_CLASS_H


/* Includes ------------------------------------------------------------------*/

#include "Component_class.h"


/* Classes  ------------------------------------------------------------------*/

/** An abstract class for Motor components.
 */
class Motor : public Component
{
public:
	/* ACTION 1 --------------------------------------------------------------*
	 * Declare here the interface's methods.                                  *
	 * They should be:                                                        *
	 *   + Methods with the same name of the C component's virtual table      *
	 *     (and extended virtual table, if any)'s functions, provided that    *
	 *     the component's driver implements them (i.e.: the corresponding    *
	 *     pointer to function is not "0").                                   *
	 *                                                                        *
	 * Example:                                                               *
	 *    virtual int GetValue(float *f) = 0;                                 *
	 *------------------------------------------------------------------------*/
	 
	/**
     * @brief  Getting the current speed in pps.
     * @param  None.
     * @retval The current speed in pps.
     */
	virtual uint16_t GetCurrentSpeed(uint8_t motorId) = 0;
	
	/**
 	* @brief Returns the device state
 	* @param[in] motorId from 0 to MAX_NUMBER_OF_BRUSH_DC_MOTORS 
 	* @retval State (STEADY or INACTIVE)
 	*/
	virtual motorState_t GetDeviceState(uint8_t motorId) = 0;
	
	/**
 	* @brief Returns the FW version of the library
 	* @retval L6206_FW_VERSION
 	*/
	virtual uint8_t GetFwVersion(void) = 0;
	
	/**
 	* @brief  Returns the max  speed of the specified motor
 	* @param[in] motorId from 0 to MAX_NUMBER_OF_BRUSH_DC_MOTORS 
 	* @retval maxSpeed in % from 0 to 100
 	*/
	virtual uint16_t GetMaxSpeed(uint8_t motorId) = 0;
	
	/**
 	* @brief  Stops the motor without disabling the bridge
 	* @param[in] motorId from 0 to MAX_NUMBER_OF_BRUSH_DC_MOTORS 
 	* @retval none
 	*/
	virtual void HardStop(uint8_t motorId) = 0;
	
	/**
 	* @brief  Runs the motor
 	* @param[in] motorId from 0 to MAX_NUMBER_OF_BRUSH_DC_MOTORS 
 	* @param[in] direction FORWARD or BACKWARD
 	* @retval None
 	* @note  For unidirectionnal motor, direction parameter has no effect
 	*/
	virtual void Run(uint8_t stepCount, motorDir_t direction) = 0;
	
	/**
 	* @brief  Changes the max speed of the specified device
 	* @param[in] motorId from 0 to MAX_NUMBER_OF_BRUSH_DC_MOTORS 
 	* @param[in] newMaxSpeed in % from 0 to 100
 	* @retval true if the command is successfully executed, else false
 	*/
	virtual bool SetMaxSpeed(uint8_t motorId, uint16_t newMaxSpeed) = 0;
	
	/**
 	* @brief Disable the specified bridge
 	* @param[in] bridgeId (from 0 for bridge A to 1 for bridge B)
 	* @retval None
 	* @note  When input of different brigdes are parallelized 
 	* together, the disabling of one bridge leads to the disabling
 	* of the second one
 	*/
	virtual void CmdDisable(uint8_t bridgeId) = 0;
	
	/**
 	* @brief Enable the specified bridge
 	* @param[in] bridgeId (from 0 for bridge A to 1 for bridge B)
 	* @retval None
 	* @note  When input of different brigdes are parallelized 
 	* together, the enabling of one bridge leads to the enabling
 	* of the second one
 	*/
	virtual void CmdEnable(uint8_t bridgeId) = 0;
	
	/**
 	* @brief  Get the status of the bridge enabling of the corresponding bridge
 	* @param[in] bridgeId from 0 for bridge A to 1 for bridge B
 	* @retval State of the Enable&Flag pin of the corresponding bridge (1 set, 0 for reset)
  	*/
	virtual uint16_t CmdGetStatus(uint8_t bridgeId) = 0;
	
	/**
 	* @brief  Immediatly stops the motor and disable the power bridge
 	* @param[in] motorId from 0 to MAX_NUMBER_OF_BRUSH_DC_MOTORS 
 	* @retval None
 	* @note  if two motors uses the same power bridge, the 
 	* power bridge will be disable only if the two motors are stopped
 	*/
	virtual void CmdHardHiZ(uint8_t motorId) = 0;
	
	/**
 	* @brief Error handler which calls the user callback (if defined)
 	* @param[in] error Number of the error
 	* @retval None
 	*/
	virtual void ErrorHandler(uint16_t error) = 0;
	
	/**
 	* @brief Set dual full bridge parallelling configuration
 	* @param[in] newConfig bridge configuration to apply from 
 	* dualFullBridgeConfig_t enum
 	* @retval None
 	*/
	virtual void SetDualFullBridgeConfig(uint8_t newConfig) = 0;
	
	/**
 	* @brief  Get the PWM frequency of the specified bridge 
 	* @param[in] bridgeId 0 for bridge A, 1 for bridge B
 	* @retval Freq in Hz
 	*/
	virtual uint32_t GetBridgeInputPwmFreq(uint8_t bridgeId) = 0;
	
	/**
 	* @brief  Changes the PWM frequency of the bridge input
 	* @param[in] bridgeId 0 for bridge A, 1 for bridge B
 	* @param[in] newFreq in Hz
 	* @retval None
 	*/
	virtual void SetBridgeInputPwmFreq(uint8_t bridgeId, uint32_t newFreq) = 0;
	
	/**
 	* @brief  Sets the number of devices to be used
 	* @param[in] nbDevices (from 1 to MAX_NUMBER_OF_DEVICES)
 	* @retval TRUE if successfull, FALSE if failure, attempt to set a number of
 	* devices greater than MAX_NUMBER_OF_DEVICES
 	*/
	virtual bool SetNbDevices(uint8_t nbDevices) = 0;
};

#endif /* __MOTOR_CLASS_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/

