/**
 ******************************************************************************
 * @file    x_nucleo_ihm02a1_class.h
 * @author  AST / Software Platforms and Cloud
 * @version V1.0
 * @date    November 3rd, 2015
 * @brief   Class header file for the X_NUCLEO_IHM02A1 expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Generated with Stm32CubeTOO -----------------------------------------------*/


/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef __X_NUCLEO_IHM02A1_CLASS_H
#define __X_NUCLEO_IHM02A1_CLASS_H


/* Includes ------------------------------------------------------------------*/

/* ACTION 1 ------------------------------------------------------------------*
 * Include here platform specific header files.                               *
 *----------------------------------------------------------------------------*/        
#include "mbed.h"
#include "DevSPI.h"
/* ACTION 2 ------------------------------------------------------------------*
 * Include here expansion board specific header files.                        *
 *----------------------------------------------------------------------------*/        
#include "x_nucleo_ihm02a1_config.h"
/* ACTION 3 ------------------------------------------------------------------*
 * Include here expansion board's components' header files.                   *
 *                                                                            *
 * Example:                                                                   *
 *   #include "component_1_class.h"                                           *
 *   #include "component_2_class.h"                                           *
 *----------------------------------------------------------------------------*/
#include "l6470_class.h"


/* Classes -------------------------------------------------------------------*/

/** Class representing a X_NUCLEO_IHM02A1 board.
 */
class X_NUCLEO_IHM02A1
{
public:

    /*** Instance, Initialization and Destructor Methods ***/

    /**
     * @brief Getting a singleton instance of X_NUCLEO_IHM02A1 class.
     * @param flag_irq      pin name of the FLAG pin of the component.
     * @param standby_reset pin name of the STBY\RST pin of the component.
     * @param ssel          pin name of the SSEL pin of the SPI device to be used for communication.
     * @param spi           SPI device to be used for communication.
     * @retval a singleton instance of X_NUCLEO_IHM02A1 class.
     */
    static X_NUCLEO_IHM02A1 *Instance(PinName flag_irq, PinName standby_reset, PinName ssel, DevSPI *spi = NULL);

    /**
     * @brief Getting a singleton instance of X_NUCLEO_IHM02A1 class.
     * @param flag_irq      pin name of the FLAG pin of the component.
     * @param standby_reset pin name of the STBY\RST pin of the component.
     * @param ssel          pin name of the SSEL pin of the SPI device to be used for communication.
     * @param mosi          pin name of the MOSI pin of the SPI device to be used for communication.
     * @param miso          pin name of the MISO pin of the SPI device to be used for communication.
     * @param sclk          pin name of the SCLK pin of the SPI device to be used for communication.
     * @retval a singleton instance of X_NUCLEO_IHM02A1 class.
     */
    static X_NUCLEO_IHM02A1 *Instance(PinName flag_irq, PinName standby_reset, PinName ssel, PinName miso, PinName mosi, PinName sclk);

    /**
     * @brief Initializing the X_NUCLEO_IHM02A1 board.
     * @retval true if initialization is successful, false otherwise.
     */
    bool Init(void);

    /**
     * @brief Destructor.
     */
    ~X_NUCLEO_IHM02A1(void) {}


    /*** Public Expansion Board Related Attributes ***/

    /* ACTION 4 --------------------------------------------------------------*
     * Declare here a public attribute for each expansion board's component.  *
     * You will have to call these attributes' public methods within your     *
     * main program.                                                          *
     *                                                                        *
     *   Example:                                                             *
     *     COMPONENT_1 *component_1;                                          *
     *     COMPONENT_2 *component_2;                                          *
     *------------------------------------------------------------------------*/
    L6470 *l6470_0;
    L6470 *l6470_1;

    /* Static data. */
    static const MICROSTEPPING_MOTOR_InitTypeDef MotorParameterInitData[EXPBRD_MOUNTED_NR_MAX][L6470DAISYCHAINSIZE];


protected:

    /*** Protected Constructor Method ***/

    /**
     * @brief Constructor.
     * @param flag_irq      pin name of the FLAG pin of the component.
     * @param standby_reset pin name of the STBY\RST pin of the component.
     * @param ssel          pin name of the SSEL pin of the SPI device to be used for communication.
     * @param spi           SPI device to be used for communication.
     */
    X_NUCLEO_IHM02A1(PinName flag_irq, PinName standby_reset, PinName ssel, DevSPI *spi);


    /*** Protected Expansion Board Related Initialization Methods ***/

    /* ACTION 5 --------------------------------------------------------------*
     * Declare here a protected initialization method for each expansion      *
     * board's component.                                                     *
     *                                                                        *
     * Example:                                                               *
     *   bool Init_COMPONENT_1(void);                                         *
     *   bool Init_COMPONENT_2(void);                                         *
     *------------------------------------------------------------------------*/
    bool Init_L6470_0(void);
    bool Init_L6470_1(void);


    /*** Component's Instance Variables ***/

    /* Singleton instance of X_NUCLEO_IHM02A1 class. */
    static X_NUCLEO_IHM02A1 *_instance;

    /* IO Device. */
    DevSPI *dev_spi;

    /* Data. */
    /* ACTION 11 -------------------------------------------------------------*
     * Declare here the component's data, one variable per line.              *
     *                                                                        *
     * Example:                                                               *
     *   uint8_t ExpansionBoard_Id;                                           *
     *------------------------------------------------------------------------*/
    uint8_t X_NUCLEO_IHM02A1_Id;

    /* Static data. */
    static uint8_t number_of_boards;
};

#endif // __X_NUCLEO_IHM02A1_CLASS_H

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/ 
