/**
 ******************************************************************************
 * @file    x_nucleo_ihm02a1_class.cpp
 * @author  AST / Software Platforms and Cloud
 * @version V1.0
 * @date    November 3rd, 2015
 * @brief   Implementation file for the X_NUCLEO_IHM02A1 expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Generated with Stm32CubeTOO -----------------------------------------------*/


/* Includes ------------------------------------------------------------------*/

/* ACTION 1 ------------------------------------------------------------------*
 * Include here platform specific header files.                               *
 *----------------------------------------------------------------------------*/        
#include "mbed.h"
#include "DevSPI.h"
/* ACTION 2 ------------------------------------------------------------------*
 * Include here expansion board specific header files.                        *
 *----------------------------------------------------------------------------*/        
#include "x_nucleo_ihm02a1_class.h"


/* Static variables ----------------------------------------------------------*/

/* Singleton instance of X_NUCLEO_IHM02A1 class. */
X_NUCLEO_IHM02A1 *X_NUCLEO_IHM02A1::_instance;

/* Number of instantiated expansion boards. */
uint8_t X_NUCLEO_IHM02A1::number_of_boards = 0;

/**
  * @brief This array contains the initial parameters for the motors that are
  *        linked with each L6470 mounted on each stacked X-NUCLEO-IHM02A1.
  */
const MICROSTEPPING_MOTOR_InitTypeDef X_NUCLEO_IHM02A1::MotorParameterInitData[EXPBRD_MOUNTED_NR_MAX][L6470DAISYCHAINSIZE] =
{
  {
    {
      9.0, 400, 1.7, 3.06, 300.0, 500.0, 500.0, 400.0, 0.0, 602.7, 3.06, 3.06,\
      3.06, 3.06, 61.52, 392.1569e-6, 643.1372e-6, 643.1372e-6, 0,\
      3.06*1000*1.10, 3.06*1000*1.00, MICROSTEP_1_128, 0xFF, 0x2E88
    },
    {
      9.0, 400, 1.7, 3.06, 300.0, 500.0, 500.0, 400.0, 0.0, 602.7, 3.06, 3.06,\
      3.06, 3.06, 61.52, 392.1569e-6, 643.1372e-6, 643.1372e-6, 0,\
      3.06*1000*1.10, 3.06*1000*1.00, MICROSTEP_1_128, 0xFF, 0x2E88
    },
  },
  {
    {
      9.0, 400, 1.7, 3.06, 300.0, 500.0, 500.0, 400.0, 0.0, 602.7, 3.06, 3.06,\
      3.06, 3.06, 61.52, 392.1569e-6, 643.1372e-6, 643.1372e-6, 0,\
      3.06*1000*1.10, 3.06*1000*1.00, MICROSTEP_1_128, 0xFF, 0x2E88
    },
    {
      9.0, 400, 1.7, 3.06, 300.0, 500.0, 500.0, 400.0, 0.0, 602.7, 3.06, 3.06,\
      3.06, 3.06, 61.52, 392.1569e-6, 643.1372e-6, 643.1372e-6, 0,\
      3.06*1000*1.10, 3.06*1000*1.00, MICROSTEP_1_128, 0xFF, 0x2E88
    },
  },
  {
    {
      9.0, 400, 1.7, 3.06, 300.0, 500.0, 500.0, 400.0, 0.0, 602.7, 3.06, 3.06,\
      3.06, 3.06, 61.52, 392.1569e-6, 643.1372e-6, 643.1372e-6, 0,\
      3.06*1000*1.10, 3.06*1000*1.00, MICROSTEP_1_128, 0xFF, 0x2E88
    },
    {
      9.0, 400, 1.7, 3.06, 300.0, 500.0, 500.0, 400.0, 0.0, 602.7, 3.06, 3.06,\
      3.06, 3.06, 61.52, 392.1569e-6, 643.1372e-6, 643.1372e-6, 0,\
      3.06*1000*1.10, 3.06*1000*1.00, MICROSTEP_1_128, 0xFF, 0x2E88
    },
  },
  {
    {
      9.0, 400, 1.7, 3.06, 300.0, 500.0, 500.0, 400.0, 0.0, 602.7, 3.06, 3.06,\
      3.06, 3.06, 61.52, 392.1569e-6, 643.1372e-6, 643.1372e-6, 0,\
      3.06*1000*1.10, 3.06*1000*1.00, MICROSTEP_1_128, 0xFF, 0x2E88
    },
    {
      9.0, 400, 1.7, 3.06, 300.0, 500.0, 500.0, 400.0, 0.0, 602.7, 3.06, 3.06,\
      3.06, 3.06, 61.52, 392.1569e-6, 643.1372e-6, 643.1372e-6, 0,\
      3.06*1000*1.10, 3.06*1000*1.00, MICROSTEP_1_128, 0xFF, 0x2E88
    },
  },
};


/* Methods -------------------------------------------------------------------*/

/**
 * @brief Constructor.
 * @param flag_irq      pin name of the FLAG pin of the component.
 * @param standby_reset pin name of the STBY\RST pin of the component.
 * @param ssel          pin name of the SSEL pin of the SPI device to be used for communication.
 * @param spi           SPI device to be used for communication.
 */
X_NUCLEO_IHM02A1::X_NUCLEO_IHM02A1(PinName flag_irq, PinName standby_reset, PinName ssel, DevSPI *spi) : dev_spi(spi)
{
    /* Instantiating the components. */
    /* ACTION 3 --------------------------------------------------------------*
     * Instantiate here the expansion board's components.                     *
     *                                                                        *
     * Example:                                                               *
     *   component_1 = new COMPONENT_1(COMPONENT_1_SPI_SSEL, *dev_spi);       *
     *   component_2 = new COMPONENT_2(COMPONENT_2_SPI_SSEL, *dev_spi);       *
     *------------------------------------------------------------------------*/
    X_NUCLEO_IHM02A1_Id = number_of_boards++;
    l6470_0 = new L6470(flag_irq, standby_reset, ssel, *dev_spi);
    l6470_1 = new L6470(flag_irq, standby_reset, ssel, *dev_spi);
}

/**
 * @brief Getting a singleton instance of X_NUCLEO_IHM02A1 class.
 * @param flag_irq      pin name of the FLAG pin of the component.
 * @param standby_reset pin name of the STBY\RST pin of the component.
 * @param ssel          pin name of the SSEL pin of the SPI device to be used for communication.
 * @param spi           SPI device to be used for communication.
 * @retval a singleton instance of X_NUCLEO_IHM02A1 class.
 */
X_NUCLEO_IHM02A1 *X_NUCLEO_IHM02A1::Instance(PinName flag_irq, PinName standby_reset, PinName ssel, DevSPI *spi)
{
    if (_instance == NULL)
    {
        /* SPI communication. */
        if (spi == NULL)
            spi = new DevSPI(X_NUCLEO_IHM02A1_PIN_SPI_MOSI, X_NUCLEO_IHM02A1_PIN_SPI_MISO, X_NUCLEO_IHM02A1_PIN_SPI_SCLK);

        /* Instantiating the board. */
        _instance = new X_NUCLEO_IHM02A1(flag_irq, standby_reset, ssel, spi);

        /* Initializing the components. */
        if (!_instance->Init())
            error("Initialization of the X_NUCLEO_IHM02A1 expansion board failed.\n");
    }

    return _instance;
}

/**
 * @brief Getting a singleton instance of X_NUCLEO_IHM02A1 class.
 * @param flag_irq      pin name of the FLAG pin of the component.
 * @param standby_reset pin name of the STBY\RST pin of the component.
 * @param ssel          pin name of the SSEL pin of the SPI device to be used for communication.
 * @param mosi          pin name of the MOSI pin of the SPI device to be used for communication.
 * @param miso          pin name of the MISO pin of the SPI device to be used for communication.
 * @param sclk          pin name of the SCLK pin of the SPI device to be used for communication.
 * @retval a singleton instance of X_NUCLEO_IHM02A1 class.
 */
X_NUCLEO_IHM02A1 *X_NUCLEO_IHM02A1::Instance(PinName flag_irq, PinName standby_reset, PinName ssel, PinName mosi, PinName miso, PinName sclk)
{
    if (_instance == NULL)
    {
        /* SPI communication. */
        DevSPI *spi = new DevSPI(mosi, miso, sclk);

        /* Instantiating the board. */
        _instance = new X_NUCLEO_IHM02A1(flag_irq, standby_reset, ssel, spi);

        /* Initializing the components. */
        if (!_instance->Init())
            error("Initialization of the X_NUCLEO_IHM02A1 expansion board failed.\n");
    }

    return _instance;
}

/**
 * @brief Initializing the X_NUCLEO_IHM02A1 board.
 * @retval true if initialization is successful, false otherwise.
 */
bool X_NUCLEO_IHM02A1::Init(void)
{
    /* Initializing the components. */
    /* ACTION 4 --------------------------------------------------------------*
     * Initialize here the expansion board's components.                      *
     *                                                                        *
     * Example:                                                               *
     *   return (Init_COMPONENT_1() && Init_COMPONENT_2());                   *
     *------------------------------------------------------------------------*/
    return (Init_L6470_0() && Init_L6470_1());
}

/* ACTION 5 ------------------------------------------------------------------*
 * Implement here an initialization method for each expansion board's         *
 * component.                                                                 *
 *                                                                            *
 * Example:                                                                   *
 *   bool EXPANSION_BOARD::Init_COMPONENT_1(void)                             *
 *   {                                                                        *
 *     // Verifying identity.                                                 *
 *     uint8_t id = 0;                                                        *
 *     int ret = component_1->ReadID(&id);                                    *
 *     if ((ret != COMPONENT_OK) || (id != I_AM_COMPONENT_1))                 *
 *     {                                                                      *
 *       delete component_1;                                                  *
 *       component_1 = NULL;                                                  *
 *       return true;                                                         *
 *     }                                                                      *
 *                                                                            *
 *     // Configuration.                                                      *
 *     INTERFACE_InitTypeDef InitStructure;                                   *
 *     InitStructure.Property_1 = COMPONENT_1_PROPERY_1_INIT;                 *
 *     InitStructure.Property_N = COMPONENT_1_PROPERY_N_INIT;                 *
 *                                                                            *
 *     // Initialization.                                                     *
 *     if (component_1->Init(&InitStructure) != COMPONENT_OK)                 *
 *       return false;                                                        *
 *                                                                            *
 *     return true;                                                           *
 *   }                                                                        *
 *----------------------------------------------------------------------------*/
/**
 * @brief  Initialize the L6470 component.
 * @retval true if initialization is successful, false otherwise.
 */
bool X_NUCLEO_IHM02A1::Init_L6470_0(void)
{
    /* Initialization. */
    if (l6470_0->Init((void *) &MotorParameterInitData[X_NUCLEO_IHM02A1_Id][0]) != COMPONENT_OK)
        return false;

    return true;
}

/**
 * @brief  Initialize the L6470 component.
 * @retval true if initialization is successful, false otherwise.
 */
bool X_NUCLEO_IHM02A1::Init_L6470_1(void)
{
    /* Initialization. */
    if (l6470_1->Init((void *) &MotorParameterInitData[X_NUCLEO_IHM02A1_Id][1]) != COMPONENT_OK)
        return false;

    return true;
}

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/ 
