/**
 ******************************************************************************
 * @file    sound_terminal.h
 * @author  Central Labs
 * @version V1.0.0
 * @date    18-August-2015
 * @brief  This file contains all the functions prototypes for the Sound Terminal driver.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2014 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef __SOUND_TERMINAL_H
#define __SOUND_TERMINAL_H

#ifdef __cplusplus
extern "C" {
#endif
  

/* Includes ------------------------------------------------------------------*/

#include "component.h"
#include <stdint.h> 
  

/** @addtogroup BSP
  * @{
  */

/** @addtogroup Components
  * @{
  */
    
/** @addtogroup SOUND_TERMINAL
  * @{
  */

/** @defgroup SOUND_TERMINAL_Exported_Types
  * @{
  */

/** 
* @brief  SoundTerminal driver structure definition  
*/ 
typedef struct
{
  /* General */
  Status_t (*Init)(void *handle, void *init);
  Status_t (*ReadID)(void *handle, uint8_t *id);
  int32_t  (*DeInit)(void);

  /* Specific */
  int32_t  (*Play)(uint16_t *pData, uint16_t size);
  int32_t  (*Pause)(void);
  int32_t  (*Resume)(void);
  int32_t  (*Stop)(void);
  int32_t  (*PowerOn)(void);
  int32_t  (*PowerOff)(void);
  int32_t  (*Reset)(void);
  int32_t  (*SetEq)(uint8_t ram_block, uint8_t filter_number, uint32_t *filter_values);
  int32_t  (*SetTone)(uint8_t tone_gain);
  int32_t  (*SetMute)(uint8_t channel, uint8_t state); 
  int32_t  (*SetVolume)(uint8_t channel, uint8_t value);
  int32_t  (*SetFrequency)(uint32_t audio_freq);
  int32_t  (*SetDSPOption)(uint8_t option, uint8_t state);
} SOUND_TERMINAL_VTable_t;

#ifdef __cplusplus
}
#endif

#endif /* __SOUND_TERMINAL_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/ 
