/**
 ******************************************************************************
 * @file    main.cpp
 * @author  SRA
 * @version V1.0.0
 * @date    5-March-2019
 * @brief   Simple Example application for using the X_NUCLEO_IKS01A3
 *          MEMS Inertial & Environmental Sensor Nucleo expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2019 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/

/* Includes */
#include "mbed.h"
#include "rtos.h"
#include "XNucleoIKS01A3.h"

/* Instantiate the expansion board */
static XNucleoIKS01A3 *mems_expansion_board = XNucleoIKS01A3::instance(D14, D15, D4, D5, A3, D6, A4);

/* Retrieve the composing elements of the expansion board */
static LIS2DW12Sensor *accelerometer = mems_expansion_board->accelerometer;

InterruptIn mybutton(BUTTON1);
DigitalOut myled(LED1);

volatile int mems_event = 0;
volatile int toggle_wake_up_enable = 0;
static int wake_up_is_enabled = 1;

void pressed_cb();
void INT1_cb();

/* Simple main function */
int main()
{
    /* Attach callback to User button press */
    mybutton.fall(&pressed_cb);
    /* Attach callback to LIS2DW12 INT1 */
    accelerometer->attach_int1_irq(&INT1_cb);

    /* Enable LIS2DW12 accelerometer */
    accelerometer->enable_x();
    /* Enable Wake-Up Detection. */
    accelerometer->enable_wake_up_detection();

    printf("\r\n--- Starting new run ---\r\n");

    while (1) {
        if (toggle_wake_up_enable) {
            toggle_wake_up_enable = 0;
            if (wake_up_is_enabled == 0) {
                accelerometer->enable_wake_up_detection();
                wake_up_is_enabled = 1;
            } else {
                accelerometer->disable_wake_up_detection();
                wake_up_is_enabled = 0;
            }
        }

        if (mems_event) {
            mems_event = 0;
            LIS2DW12_Event_Status_t status;
            accelerometer->get_event_status(&status);
            if (status.WakeUpStatus) {
                /* Led blinking. */
                myled = 1;
                ThisThread::sleep_for(200);
                myled = 0;

                /* Output data. */
                printf("Wake Up Detected!\r\n");
            }
        }
    }
}

void pressed_cb()
{
    toggle_wake_up_enable = 1;
}

void INT1_cb()
{
    mems_event = 1;
}
