/**
 ******************************************************************************
 * @file    main.cpp
 * @author  AST / EST
 * @version V0.0.1
 * @date    9-August-2016
 * @brief   Simple Example application for using the X_NUCLEO_IKS01A2 
 *          MEMS Inertial & Environmental Sensor Nucleo expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/ 

/* Includes */
#include "mbed.h"
#include "x_nucleo_iks01a2.h"

/* Instantiate the expansion board */
static X_NUCLEO_IKS01A2 *mems_expansion_board = X_NUCLEO_IKS01A2::Instance(D14, D15);

/* Retrieve the composing elements of the expansion board */
static LSM6DSLSensor *acc_gyro = mems_expansion_board->acc_gyro;

InterruptIn lsm6dsl_int1(IKS01A2_PIN_LSM6DSL_INT1);
InterruptIn mybutton(USER_BUTTON);
DigitalOut myled(LED1);

volatile int wake_up = 0;
volatile int toggle_wake_up_enable = 0;
static int wake_up_is_enabled = 1;

void pressed();
void wakeup();

/* Simple main function */
int main() {
  /* Attach callback to User button press */
  mybutton.fall(&pressed);
  /* Attach callback to LSM6DSL INT1 */
  lsm6dsl_int1.rise(&wakeup);
  
  /* Enable LSM6DSL accelerometer */
  acc_gyro->Enable_X();
  /* Enable Wake-Up Detection. */
  acc_gyro->Enable_Wake_Up_Detection();
  
  printf("\r\n--- Starting new run ---\r\n");
 
  while(1) {
    if(toggle_wake_up_enable) {
      toggle_wake_up_enable = 0;
      if(wake_up_is_enabled == 0) {
        acc_gyro->Enable_Wake_Up_Detection();
        wake_up_is_enabled = 1;
      } else {
        acc_gyro->Disable_Wake_Up_Detection();
        wake_up_is_enabled = 0;
      }
    }
 
    if (wake_up) {
      wake_up = 0;
      uint8_t status = 0;
      acc_gyro->Get_Status_Wake_Up_Detection(&status);
      if (status) {
        /* Led blinking. */
        myled = 1;
        wait(0.2);
        myled = 0;

        /* Output data. */
        printf("Wake Up Detected!\r\n");
      }
    }
  }
}

void pressed() {
  toggle_wake_up_enable = 1;
}

void wakeup() {
  wake_up = 1;
}
