/**
 ******************************************************************************
 * @file    main.cpp
 * @author  SRA
 * @version V1.0.0
 * @date    5-March-2019
 * @brief   Simple Example application for using the X_NUCLEO_IKS01A3
 *          MEMS Inertial & Environmental Sensor Nucleo expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2019 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/

/* Includes */
#include "mbed.h"
#include "rtos.h"
#include "XNucleoIKS01A3.h"

/* Instantiate the expansion board */
static XNucleoIKS01A3 *mems_expansion_board = XNucleoIKS01A3::instance(D14, D15, D4, D5, A3, D6, A4);

/* Retrieve the composing elements of the expansion board */
static LSM6DSOSensor *acc_gyro = mems_expansion_board->acc_gyro;

InterruptIn mybutton(BUTTON1);
DigitalOut myled(LED1);

volatile int mems_event = 0;
volatile int toggle_tilt_enable = 0;
static int tilt_is_enabled = 1;

/* User button callback. */
void pressed_cb()
{
    toggle_tilt_enable = 1;
}

/* Interrupt 1 callback. */
void int1_cb()
{
    mems_event = 1;
}

/* Simple main function */
int main()
{
    /* Attach callback to User button press */
    mybutton.fall(&pressed_cb);
    /* Attach callback to LSM6DSO INT1 */
    acc_gyro->attach_int1_irq(&int1_cb);

    /* Enable LSM6DSO accelerometer */
    acc_gyro->enable_x();
    /* Enable Tilt Detection. */
    acc_gyro->enable_tilt_detection();

    printf("\r\n--- Starting new run ---\r\n");

    while (1) {
        if (toggle_tilt_enable) {
            toggle_tilt_enable = 0;
            if (tilt_is_enabled == 0) {
                acc_gyro->enable_tilt_detection();
                tilt_is_enabled = 1;
            } else {
                acc_gyro->disable_tilt_detection();
                tilt_is_enabled = 0;
            }
        }

        if (mems_event) {
            mems_event = 0;
            LSM6DSO_Event_Status_t status;
            acc_gyro->get_event_status(&status);
            if (status.TiltStatus) {
                /* Led blinking. */
                myled = 1;
                ThisThread::sleep_for(200);
                myled = 0;

                /* Output data. */
                printf("Tilt Detected!\r\n");
            }
        }
    }
}
