/******************************************************************************
  * @file    CustomControlService.h
  * @author  Fabio Brembilla
  * @version V1.0.0
  * @date    April, 2016
  * @brief   SunTracker Custom Service for BlueTooth (IDB0XA1 expansion board)
  *****************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
*/

#include "BLE.h"
#include "UUID.h"

#define STORE_BE_32(buf, val)    ( ((buf)[3] =  (uint8_t) (val)     ) , \
                                   ((buf)[2] =  (uint8_t) (val>>8)  ) , \
                                   ((buf)[1] =  (uint8_t) (val>>16) ) , \
                                   ((buf)[0] =  (uint8_t) (val>>24) ) )     
                
/* BLE Services: Primary + 1 Secondary (Char Desk) */
//const LongUUIDBytes_t CONTROL_SERVICE_UUID = {0x00,0x00,0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A}; //Primary
//const LongUUIDBytes_t USER_BUTTON_CHAR_UUID    = {0x00,0x00,0x00,0x01,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A}; //User Button Control
//const ShortUUIDBytes_t CONTROL_SERVICE_UUID  = 0xA000;
//const ShortUUIDBytes_t CONTROL_COMMAND_CHAR_UUID = 0xA001;                      

/* BLE Services: Primary + 1 Secondary (Char Desk) */
const UUID::LongUUIDBytes_t CONTROL_SERVICE_UUID        = {0x00,0x00,0x00,0x00,0x00,0x0F,0x11,0xe1,0x9a,0xb4,0x00,0x02,0xa5,0xd5,0xc5,0x1b};
//const LongUUIDBytes_t CONTROL_REGISTER_CHAR_UUID  = {0x00,0x00,0x00,0x01,0x00,0x0F,0x11,0xe1,0xac,0x36,0x00,0x02,0xa5,0xd5,0xc5,0x1b}; //Not Used
const UUID::LongUUIDBytes_t CONTROL_COMMAND_CHAR_UUID   = {0x00,0x00,0x00,0x02,0x00,0x0F,0x11,0xe1,0xac,0x36,0x00,0x02,0xa5,0xd5,0xc5,0x1b};

//#define SIZEOF_CONTROL_DATA_LEN     2
// 1 byte   0xFF        8 bit      int8
// 2 byte   0xFFFF      16 bit     int16
// 4 byte   0xFFFFFFFF  32 bit     int32
#define COMMAND_DATA_LEN         2+4+1+2 // TimeStamp (only for Response) + Feature + Type + Data

/* Custom Control Service */
class CustomControlService  {
public:
    CustomControlService(BLE &_ble) :
        ble(_ble),
                commandCharacteristic(CONTROL_COMMAND_CHAR_UUID, commandData, COMMAND_DATA_LEN, COMMAND_DATA_LEN,                                        
                                         GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
        {  
        static bool serviceAdded = false; // To be sure to define just one time
        if (serviceAdded) {
            return;
        }

        GattCharacteristic *charTable[] = {&commandCharacteristic};
        GattService   controlService(CONTROL_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));              
        ble.gattServer().addService(controlService);                              
                
        isEnabledCommandNotify          = false;
        memset (commandData, 0, COMMAND_DATA_LEN);
        isBTLEConnected                 = DISCONNECTED;
        serviceAdded                    = true;
    }

// Tests Method

/* BlueMicrosystem1 (only for Response)

    uint32_t sendcontrolState(uint8_t val, uint8_t Command, uint32_t Feature, uint16_t TimeStamp) {      
            STORE_LE_16(commandData ,TimeStamp); 
            STORE_BE_32(commandData+2,Feature);          
            commandData[6] = Command;
            commandData[7] = (val==0x01) ? 100: val;                     
            return ble.gattServer().write(commandCharacteristic.getValueAttribute().getHandle(), commandData, COMMAND_DATA_LEN, 0);
    }
    
    uint32_t updatecontrolState(uint8_t val, uint8_t Command, uint32_t Feature, uint16_t TimeStamp) {
            if (ble.getGapState().connected && isEnabledCommandNotify ) {  
                return sendcontrolState(val, Command, Feature, TimeStamp);
            }
            return 0;
    }
*/

/* Old SunTracker

   void sendCommandState(uint8_t State) {
            STORE_LE_16(commandData,State);
            PRINTF("sendCommandState handle: %d\n\r", commandCharacteristic.getValueAttribute().getHandle());
            memcpy (pastcommandData, commandData, COMMAND_DATA_LEN);
            ble.gattServer().write(commandCharacteristic.getValueAttribute().getHandle(), commandData, COMMAND_DATA_LEN, 0);         
            printf(" (Update)"); 
    } 

    void updateCommandState(uint8_t State) {
            if (ble.getGapState().connected && isEnabledCommandNotify ) { 
                if (memcmp (&pastcommandData[0], &State, COMMAND_DATA_LEN) != 0) {
                    sendCommandState(State);           
                }
            }
    }

*/  

    void enNotify (Gap::Handle_t handle) {
            printf("\n\r\n\renNotify (handle %d)", handle);
            if (isCommandHandle(handle)) { isEnabledCommandNotify = true; return; }    
    }
    
    void disNotify (Gap::Handle_t handle) {
            printf("\n\r\n\rdisNotify (handle %d)", handle);
            if (isCommandHandle(handle)) { isEnabledCommandNotify = false; return; }    
    }   

    bool isCommandNotificationEn (void) {
            return isEnabledCommandNotify;
    }
    
    bool isCommandHandle (Gap::Handle_t handle) {
            if (handle == commandCharacteristic.getValueAttribute().getHandle()) return true;
            return false;
    }
    
    void updateConnectionStatus(ConnectionStatus_t status) {            
            isEnabledCommandNotify = false;
            memset (commandData, 0, COMMAND_DATA_LEN);
            isBTLEConnected = status;             
    }      

// Variables Initialization
private:
        BLE                              &ble;
        uint8_t                          commandData[COMMAND_DATA_LEN];                
        uint8_t                          pastcommandData[COMMAND_DATA_LEN]; 
        GattCharacteristic               commandCharacteristic;  
        ConnectionStatus_t               isBTLEConnected;
        bool                             isEnabledCommandNotify;

};
