/**
 ******************************************************************************
 * @file    main.cpp
 * @author  Fabio Brembilla
 * @version V2.0.0
 * @date    January 22th, 2016
 * @brief   SunTracker + RemoteControl Vertical Application
 *          This application use IHM01A1, 6180XA1, IKS01A1, IDB0XA1 expansion boards
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */

/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"

/* Helper header files. */
#include "DevSPI.h"
#include "DevI2C.h"

/* Component specific header files. */
#include "l6474_class.h"
#include "x_nucleo_6180xa1.h"
#include "x_nucleo_iks01a1.h"

/* C header files. */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

/* BlueTooth -----------------------------------------------------------------*/

#include "debug.h" // Need for PRINTF
#include "Utils.h" // Need for STORE_LE_16 and _32

typedef struct {
    int32_t AXIS_X;
    int32_t AXIS_Y;
    int32_t AXIS_Z;
} AxesRaw_TypeDef;

typedef enum ConnectionStatus_t {
    DISCONNECTED    =0,
    CONNECTED       =1
}cns_t;

const unsigned   LENGTH_OF_LONG_UUID = 16;
typedef uint16_t ShortUUIDBytes_t;
typedef uint8_t  LongUUIDBytes_t[LENGTH_OF_LONG_UUID];

#include "CustomControlService.h"
#include "CustomSensorsService.h"

static BLE * p_BLEdev = NULL;

#define BLE_DEV_NAME "SunTrack"
#define BLE_DEV_MAC 0xAA,0xBB,0xCC,0xDD,0xEE,0xFF
#define BLE_ADVERTISING_INTERVAL 1000

/* Definitions ---------------------------------------------------------------*/

#define SET_ACC 400     // Set Motor Acceleration
#define SET_DEC 400     // Set Motor Deceleration
#define SET_MAX 200     // Set Motor MaxSpeed
#define SET_MIN 100     // Set Motor MinSpeed
#define STOP 1000       // Set Motor Stop Position
#define TOLLERANCE 100  // Tollerance between Left and Right before Start Movement
#define RANGE_1 200     // Range 1 for Motor Speed
#define RANGE_2 500     // Range 2 for Motor Speed

/* Variables -----------------------------------------------------------------*/

int16_t dir=0;          // Motor Rotation Direction: 0 = Stop, 1 = Anticlockwise, 2 = Clockwise
int16_t changedir=0;    // Change Direction: 0 = No, 1 = Yes
int16_t babybear=0;     // Difference (in Lux) between Left and Right
int acc_data[3];        // Difference of Accelerometer
int16_t diff=0;         // Abs of Babybear or Accelerometer difference
int16_t left=0;         // Left Command for Rotate Direction
int16_t right=0;        // Right Command for Rotate Direction
int16_t start=0;        // Waiting User Button Push
int32_t pos=0;          // Motor Position
char DisplayStr[5];     // Status Display
int16_t Display=0;      // Shown on Display: 0 = Motor Speed, 1 = Solar Panel Value, 2 = Manual Control
int16_t status, status_t, status_b, status_l, status_r; // Babybear Status

/* ---------------------------------------------------------------------------*/



/* Bluetooth CallBack ---------------------------------------------------------*/

static void onUpdatesEnabledCallback(GattAttribute::Handle_t handle)
{
    
}

static void onUpdatesDisabledCallback(Gap::Handle_t handle)
{
    
}

static void onDataReadCallback(const GattReadCallbackParams *eventDataP)
{
    
}

static void myonDataWriteCallback(const GattWriteCallbackParams *eventDataP)
{
    
}

static void onConnectionCallback(const Gap::ConnectionCallbackParams_t * connectionParams)
{
    
}

static void onDisconnectionCallback(const Gap::DisconnectionCallbackParams_t * disConnectionReason)
{
    
}

/* Bluetooth Initialization ---------------------------------------------------*/

void BLE_Initialization(void)
{

    p_BLEdev = new BLE;
    if (!p_BLEdev) { printf("\r\nBLE Device creation failed\r\n"); }
  
    const Gap::Address_t BLE_address_BE = {BLE_DEV_MAC};        
    p_BLEdev->gap().setAddress(BLEProtocol::AddressType::PUBLIC, BLE_address_BE);
printf("Line: %d \r\n", __LINE__);       
    p_BLEdev->init();         
printf("Line: %d \r\n", __LINE__);    

    // Set BLE CallBack Functions
    p_BLEdev->gattServer().onUpdatesEnabled(onUpdatesEnabledCallback);
    p_BLEdev->gattServer().onUpdatesDisabled(onUpdatesDisabledCallback);
    p_BLEdev->gattServer().onDataRead(onDataReadCallback);
    p_BLEdev->gattServer().onDataWritten(myonDataWriteCallback);
    p_BLEdev->gap().onConnection(onConnectionCallback);
    p_BLEdev->gap().onDisconnection(onDisconnectionCallback);
    //p_BLEdev->gattServer().onConfirmationReceived(onConfirmationReceivedCallback);    
    //p_BLEdev->gattServer().onDataSent(onDataSentCallback);    
    //p_BLEdev->gap().onTimeout(onTimeoutCallback);

}

/* Main ----------------------------------------------------------------------*/

int main()
{

    //Initialization();
printf("Line: %d \r\n", __LINE__);  
    BLE_Initialization();
printf("Line: %d \r\n", __LINE__);  
    
    /* Setup advertising. */
    const static char     DEVICE_NAME[] = BLE_DEV_NAME;
    p_BLEdev->gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    #ifdef USE_SENSOR_FUSION_LIB        
    uint8_t dat[]= {0x01,0x80,0x00,0xFC,0x01,0x80};
    #else
    uint8_t dat[]= {0x01,0x80,0x00,0xFC,0x00,0x00};
    #endif      
    p_BLEdev->gap().accumulateScanResponse(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA,dat,6);    
    p_BLEdev->gap().accumulateAdvertisingPayload(GapAdvertisingData::UNKNOWN);
    p_BLEdev->gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    p_BLEdev->gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    p_BLEdev->gap().setAdvertisingInterval(BLE_ADVERTISING_INTERVAL);
    p_BLEdev->gap().startAdvertising();

    /* Printing to the console. */
    printf("SunTracker by Fabio Brembilla\r\n\n");
    
    /* Main Loop. */
    while(true) {
        
       
        
        
        p_BLEdev->waitForEvent();
    }


}
