/******************************************************************************
  * @file    CustomControlService.h
  * @author  Fabio Brembilla
  * @version V1.0.0
  * @date    January, 2016
  * @brief   SunTracker Custom Service for BlueTooth (IDB0XA1 expansion board)
  *****************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
*/

#ifndef __CUSTOM_BLE_CONTROL_SERVICE_H__
#define __CUSTOM_BLE_CONTROL_SERVICE_H__
#include "BLE.h"
#include "UUID.h"
                              
#define STORE_BE_32(buf, val)    ( ((buf)[3] =  (uint8_t) (val)     ) , \
                                   ((buf)[2] =  (uint8_t) (val>>8)  ) , \
                                   ((buf)[1] =  (uint8_t) (val>>16) ) , \
                                   ((buf)[0] =  (uint8_t) (val>>24) ) )                         
                            
#define SIZEOF_CONTROL_DATA_LEN  2+4+1+1

/* BLE Services: Primary + 1 Secondary (Char Desk) */
const LongUUIDBytes_t CONTROL_SERVICE_UUID_128 = {0x00,0x00,0x00,0x00,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A}; //Primary
const LongUUIDBytes_t USER_BUTTON_CHAR_UUID    = {0x00,0x00,0x00,0x01,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A}; //User Button Control

/* Custom Config Service */
class CustomConfigService  {
public:
    CustomConfigService(BLE &_ble) :
        ble(_ble),
                userbuttonCharacteristic(USER_BUTTON_CHAR_UUID, controlData, SIZEOF_CONTROL_DATA_LEN, SIZEOF_CONTROL_DATA_LEN,
                                         GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE)
        {  
        static bool serviceAdded = false; // To be sure to define just one time
        if (serviceAdded) {
            return;
        }

        GattCharacteristic *charTable[] = {&userbuttonCharacteristic};

        GattService   configService(CONTROL_SERVICE_UUID_128, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));              
                
        ble.gattServer().addService(configService);                              
                
        isEnabledControlNotify = false;
        memset (controlData, 0, SIZEOF_CONTROL_DATA_LEN); 
        serviceAdded = true;
    }

// Tests Method
//----------------INIZIO  
/*
  
    uint32_t sendcontrolState(uint32_t Feature, uint8_t Command, uint8_t val, uint16_t TimeStamp) {      
            STORE_LE_16(controlData ,TimeStamp); 
            STORE_BE_32(controlData+2,Feature);          
            controlData[6] = Command;
            controlData[7] = (val==0x01) ? 100: val;                     
            return ble.gattServer().write(userbuttonCharacteristic.getValueAttribute().getHandle(), controlData, SIZEOF_CONTROL_DATA_LEN, 0);
    }
    
    uint32_t updatecontrolState(uint32_t Feature, uint8_t Command, uint8_t val, uint16_t TimeStamp) {
            if (ble.getGapState().connected && isEnabledControlNotify ) {  
            return sendcontrolState(Feature, Command, val, TimeStamp);
            }
            return 0;
    }

    void updateConnectionStatus(ConnectionStatus_t status) {            
            isEnabledControlNotify = false;
            memset (controlData, 0, SIZEOF_CONTROL_DATA_LEN);             
            }   
    
    bool isConfHandle (Gap::Handle_t handle) {
            if (handle == userbuttonCharacteristic.getValueAttribute().getHandle()) return true;
            return false;
    }           

    void enNotify (Gap::Handle_t handle) {
            if (isConfHandle(handle)) { 
                PRINTF("enNotify! %d\n\r", handle); isEnabledControlNotify = true; return; }    
    }
    
    void disNotify (Gap::Handle_t handle) {
            if (isConfHandle(handle)) { 
                            isEnabledControlNotify = false; return; }    
    }   

*/    
//----------------FINE  

// Variables Initialization
private:
        BLE                              &ble;
        uint8_t                          controlData[SIZEOF_CONTROL_DATA_LEN];                
        uint8_t                          controlState;
        GattCharacteristic               userbuttonCharacteristic;  
        bool                             isEnabledControlNotify;

};

#endif /* #ifndef __CUSTOM_BLE_CONTROL_SERVICE_H__*/

