/* NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "mbed.h"
#include "SpwfInterface.h"
#include "NSAPITests.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
SpwfSAInterface spwf(D8, D2, false);
 
int main()
{
    int32_t err;  
    char * ssid = "STM";
    char * seckey = "STMdemoPWD";
      
    pc.printf("\r\nSpwf Interface NSAPI Tests\r\n");
    pc.printf("\r\nconnecting to AP\r\n");
            
    err = spwf.connect(ssid, seckey, NSAPI_SECURITY_WPA);
 
    if (!err) {
        printf("Interface failed to connect with code %d\r\n", err);
    } else {
        nsapi_tests("SPWF Tests", &spwf, "192.168.1.6", 32001);
        spwf.disconnect();
    }

    while(1)
    {
        wait(1);
        myled = !myled;
    }
}