/**
 *******************************************************************************
 * @file    CustomService.h
 * @author  Davide Aliprandi, STMicroelectronics
 * @version V1.0.0
 * @date    October 31st, 2017
 * @brief   mbed test application for the STMicroelectronics X-NUCLEO-IHM01A1
 *          Motor Control Expansion Board and the X-NUCLEO-IDB05A1 Bluetooth
 *          Low energy Expansion Board.
 *******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2018 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *******************************************************************************
 */
 

#ifndef __BLE_CUSTOM_SERVICE_H__
#define __BLE_CUSTOM_SERVICE_H__

#include "ble_utils.h"

#define COMMAND_DATA_LENGTH (sizeof(uint8_t))
#define MAX_DATA_LENGTH     (COMMAND_DATA_LENGTH)

const UUID::LongUUIDBytes_t CUSTOM_SERVICE_UUID            = {0x00,0x00,0x00,0x00,0x00,0x01,0x11,0xe1,0x9a,0xb4,0x00,0x02,0xa5,0xd5,0xc5,0x1b};
const UUID::LongUUIDBytes_t CUSTOM_LED_CHARACTERISTIC_UUID = {0x80,0x00,0x00,0x00,0x00,0x01,0x11,0xe1,0xac,0x36,0x00,0x02,0xa5,0xd5,0xc5,0x1b};

class CustomService {
public:

    /* Led commands. */
    typedef enum
    {
        LED_POWER_OFF = 0,  // Led Off.
        LED_POWER_ON        // Led On.
    } led_commands_t;

    CustomService(BLEDevice &_ble) :
        ble(_ble),
        command(CUSTOM_LED_CHARACTERISTIC_UUID, packed_command, MAX_DATA_LENGTH, MAX_DATA_LENGTH,
            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE)
    {
        GattCharacteristic *char_table[] = {&command};
        GattService led_service(CUSTOM_SERVICE_UUID, char_table, sizeof(char_table) / sizeof(GattCharacteristic *));
        ble.addService(led_service);
        memset (packed_command, 0, MAX_DATA_LENGTH);
    }

    GattAttribute::Handle_t getValueHandle() const
    {
        return command.getValueAttribute().getHandle();
    }

private:
    BLEDevice &ble;
    GattCharacteristic command;
    uint8_t packed_command[MAX_DATA_LENGTH];
};

#endif /* #ifndef __BLE_CUSTOM_SERVICE_H__ */
