#include "mbed.h"
#include "SpwfInterface.h"
#include "NTPClient.h"
#include "TCPSocket.h"

//www.amazon.it certificate in PEM format
char  cert []="-----BEGIN CERTIFICATE-----\r\n"
"MIIE0zCCA7ugAwIBAgIQGNrRniZ96LtKIVjNzGs7SjANBgkqhkiG9w0BAQUFADCB\r\n"
"yjELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\r\n"
"ExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBWZXJp\r\n"
"U2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW\r\n"
"ZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0\r\n"
"aG9yaXR5IC0gRzUwHhcNMDYxMTA4MDAwMDAwWhcNMzYwNzE2MjM1OTU5WjCByjEL\r\n"
"MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZW\r\n"
"ZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBWZXJpU2ln\r\n"
"biwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxWZXJp\r\n"
"U2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9y\r\n"
"aXR5IC0gRzUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCvJAgIKXo1\r\n"
"nmAMqudLO07cfLw8RRy7K+D+KQL5VwijZIUVJ/XxrcgxiV0i6CqqpkKzj/i5Vbex\r\n"
"t0uz/o9+B1fs70PbZmIVYc9gDaTY3vjgw2IIPVQT60nKWVSFJuUrjxuf6/WhkcIz\r\n"
"SdhDY2pSS9KP6HBRTdGJaXvHcPaz3BJ023tdS1bTlr8Vd6Gw9KIl8q8ckmcY5fQG\r\n"
"BO+QueQA5N06tRn/Arr0PO7gi+s3i+z016zy9vA9r911kTMZHRxAy3QkGSGT2RT+\r\n"
"rCpSx4/VBEnkjWNHiDxpg8v+R70rfk/Fla4OndTRQ8Bnc+MUCH7lP59zuDMKz10/\r\n"
"NIeWiu5T6CUVAgMBAAGjgbIwga8wDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8E\r\n"
"BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJaW1hZ2UvZ2lmMCEwHzAH\r\n"
"BgUrDgMCGgQUj+XTGoasjY5rw8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVy\r\n"
"aXNpZ24uY29tL3ZzbG9nby5naWYwHQYDVR0OBBYEFH/TZafC3ey78DAJ80M5+gKv\r\n"
"MzEzMA0GCSqGSIb3DQEBBQUAA4IBAQCTJEowX2LP2BqYLz3q3JktvXf2pXkiOOzE\r\n"
"p6B4Eq1iDkVwZMXnl2YtmAl+X6/WzChl8gGqCBpH3vn5fJJaCGkgDdk+bW48DW7Y\r\n"
"5gaRQBi5+MHt39tBquCWIMnNZBU4gcmU7qKEKQsTb47bDN0lAtukixlE0kF6BWlK\r\n"
"WE9gyn6CagsCqiUXObXbf+eEZSqVir2G3l6BFoMtEMze/aiCKm0oHw0LxOXnGiYZ\r\n"
"4fQRbxC1lfznQgUy286dUV4otp6F01vvpX1FQHKOtw5rDgb7MzVIcbidJ4vEZV8N\r\n"
"hnacRHr2lVz2XTIIM6RUthg/aFzyQkqFOFSDX9HoLPKsEdao7WNq\r\n"
"-----END CERTIFICATE-----\r\n";

SpwfSAInterface spwf(D8, D2, false);  // Wifi interface

int main() 
{
    time_t ctTime;
    ctTime = time(NULL);
    
    printf ("\n\rConnecting to WiFi ...\n\r");  
    spwf.connect("ssid","passw", NSAPI_SECURITY_WPA2);
    NTPClient ntp(spwf);        

    printf("Initial System Time is: %s\r\n", ctime(&ctTime));   
    printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0)
    {
      printf("Set time successfully\r\n");
      ctTime = time(NULL);
      printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
      if (!spwf.set_time(ctTime)) printf ("ERROR set_time\n\r");     
      if (!spwf.clean_TLS_certificate(ALL)) printf ("ERROR clean_TLS_certificate\n\r");
      if (!spwf.set_TLS_certificate(cert, sizeof(cert), FLASH_CA_ROOT_CERT)) printf ("ERROR set_TLS_certificate\n\r");
      if (!spwf.set_TLS_SRV_domain("www.amazon.it",FLASH_DOMAIN)) printf ("ERROR set_TLS_CA_domain\n\r");
// NOTE:  DNS requires UDP socket. DNS is invoked while connecting a secure socket to resolve URL to IP,
//         so DNS doesnt answer as it requires unsecure UDP socket connection.
//         workaroud: convert URL to IP quering DNS before secure socket creation, then connect 
//         the secure socket created to the  retrieved IP.
      SocketAddress addr(&spwf, "www.amazon.it");
      const char *ip=addr.get_ip_address();
      printf ("www.amazon.it resolved to: %s\n\r", ip);
      spwf.set_secure_sockets();     
      TCPSocket  socket(&spwf);           
      int err = socket.connect(ip,443);
      if (err != 0 )printf ("ERROR opening %d\n\r", err);
      else printf ("--->>> Secure socket CONNECTED to: %s\n\r", ip);
      spwf.set_unsecure_sockets();    
      socket.close();      
      printf ("Socket closed\n\r");
    }  
    else
    {
      printf("Error: NTP could not contact server\r\n");
    }    
    spwf.disconnect();
    printf ("WIFI disconnected, exiting ...\n\r");
}
